/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.dataset.valuegenerator;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.eclipse.nebula.widgets.nattable.dataset.generator.IValueGenerator;

public abstract class AbstractListValueGenerator<T>
implements IValueGenerator {
    private final List<T> listOfValues;

    public AbstractListValueGenerator(List<T> listOfValues) {
        this.listOfValues = Collections.unmodifiableList(listOfValues);
    }

    public AbstractListValueGenerator(T ... values) {
        this(Arrays.asList(values));
    }

    @Override
    public Object newValue(Random random) {
        return this.listOfValues.get(random.nextInt(this.listOfValues.size()));
    }

    protected static <V> String[] toStringArray(V ... values) {
        String[] retStrings = new String[values.length];
        int i = 0;
        while (i < values.length) {
            retStrings[i] = String.valueOf(values[i]);
            ++i;
        }
        return retStrings;
    }
}

