/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.hideshow.indicator;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.ui.NatEventData;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeDetectUtil;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Point;

public class HierarchicalRowHideIndicatorEventMatcher
extends MouseEventMatcher {
    public HierarchicalRowHideIndicatorEventMatcher(int stateMask, int button) {
        super(stateMask, "BODY", button);
    }

    @Override
    public boolean matches(NatTable natTable, MouseEvent event, LabelStack regionLabels) {
        return super.matches(natTable, event, regionLabels) && this.hasHiddenRows(natTable, event);
    }

    private boolean hasHiddenRows(ILayer natLayer, MouseEvent event) {
        int rowPosition = CellEdgeDetectUtil.getRowPosition(natLayer, new Point(event.x, event.y));
        if (rowPosition < 0) {
            return false;
        }
        NatEventData eventData = NatEventData.createInstanceFromEvent(event);
        LabelStack labels = natLayer.getConfigLabelsByPosition(eventData.getColumnPosition(), eventData.getRowPosition());
        if (labels.hasLabel("LEVEL_HEADER_CELL")) {
            LabelStack bodyLabels = natLayer.getConfigLabelsByPosition(eventData.getColumnPosition() + 1, eventData.getRowPosition());
            return bodyLabels.hasLabel("ROW_TOP_HIDDEN") || bodyLabels.hasLabel("ROW_BOTTOM_HIDDEN");
        }
        return false;
    }
}

