/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import aQute.bnd.annotation.spi.ServiceProvider;
import java.io.Serializable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.factory.map.primitive.MutableCharObjectMapFactory;
import org.eclipse.collections.api.map.primitive.CharObjectMap;
import org.eclipse.collections.api.map.primitive.MutableCharObjectMap;
import org.eclipse.collections.impl.factory.primitive.CharObjectMaps;
import org.eclipse.collections.impl.map.mutable.primitive.CharObjectHashMap;
import org.eclipse.collections.impl.utility.Iterate;

@ServiceProvider(value=MutableCharObjectMapFactory.class)
public class MutableCharObjectMapFactoryImpl
implements MutableCharObjectMapFactory {
    public static final MutableCharObjectMapFactory INSTANCE = new MutableCharObjectMapFactoryImpl();

    public <V> MutableCharObjectMap<V> empty() {
        return new CharObjectHashMap(0);
    }

    public <V> MutableCharObjectMap<V> of() {
        return this.empty();
    }

    public <V> MutableCharObjectMap<V> with() {
        return this.empty();
    }

    public <V> MutableCharObjectMap<V> of(char key, V value) {
        return this.with(key, value);
    }

    public <V> MutableCharObjectMap<V> with(char key, V value) {
        return CharObjectHashMap.newWithKeysValues(key, value);
    }

    public <V> MutableCharObjectMap<V> of(char key1, V value1, char key2, V value2) {
        return this.with(key1, value1, key2, value2);
    }

    public <V> MutableCharObjectMap<V> with(char key1, V value1, char key2, V value2) {
        return CharObjectHashMap.newWithKeysValues(key1, value1, key2, value2);
    }

    public <V> MutableCharObjectMap<V> of(char key1, V value1, char key2, V value2, char key3, V value3) {
        return this.with(key1, value1, key2, value2, key3, value3);
    }

    public <V> MutableCharObjectMap<V> with(char key1, V value1, char key2, V value2, char key3, V value3) {
        return CharObjectHashMap.newWithKeysValues(key1, value1, key2, value2, key3, value3);
    }

    public <V> MutableCharObjectMap<V> of(char key1, V value1, char key2, V value2, char key3, V value3, char key4, V value4) {
        return this.with(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public <V> MutableCharObjectMap<V> with(char key1, V value1, char key2, V value2, char key3, V value3, char key4, V value4) {
        return CharObjectHashMap.newWithKeysValues(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    public <V> MutableCharObjectMap<V> ofInitialCapacity(int capacity) {
        return this.withInitialCapacity(capacity);
    }

    public <V> MutableCharObjectMap<V> withInitialCapacity(int capacity) {
        return new CharObjectHashMap(capacity);
    }

    public <V> MutableCharObjectMap<V> ofAll(CharObjectMap<? extends V> map) {
        return this.withAll(map);
    }

    public <V> MutableCharObjectMap<V> withAll(CharObjectMap<? extends V> map) {
        if (map.isEmpty()) {
            return this.empty();
        }
        return new CharObjectHashMap<V>(map);
    }

    public <T, V> MutableCharObjectMap<V> from(Iterable<T> iterable, CharFunction<? super T> keyFunction, Function<? super T, ? extends V> valueFunction) {
        MutableCharObjectMap map = CharObjectMaps.mutable.empty();
        Iterate.forEach(iterable, (Procedure & Serializable)each -> map.put(keyFunction.charValueOf(each), valueFunction.valueOf(each)));
        return map;
    }
}

