/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyCharIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.MutableBooleanBag;
import org.eclipse.collections.api.bag.primitive.MutableByteBag;
import org.eclipse.collections.api.bag.primitive.MutableCharBag;
import org.eclipse.collections.api.bag.primitive.MutableDoubleBag;
import org.eclipse.collections.api.bag.primitive.MutableFloatBag;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.bag.primitive.MutableLongBag;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.bag.sorted.ImmutableSortedBag;
import org.eclipse.collections.api.bag.sorted.MutableSortedBag;
import org.eclipse.collections.api.bimap.MutableBiMap;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.CharToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleObjectToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.FloatObjectToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.IntObjectToIntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.LongObjectToLongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.predicate.primitive.CharObjectPredicate;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.CharObjectProcedure;
import org.eclipse.collections.api.block.procedure.primitive.CharProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.map.MutableMapIterable;
import org.eclipse.collections.api.map.primitive.CharObjectMap;
import org.eclipse.collections.api.map.primitive.ImmutableCharObjectMap;
import org.eclipse.collections.api.map.primitive.MutableCharObjectMap;
import org.eclipse.collections.api.map.primitive.MutableObjectCharMap;
import org.eclipse.collections.api.map.primitive.MutableObjectDoubleMap;
import org.eclipse.collections.api.map.primitive.MutableObjectLongMap;
import org.eclipse.collections.api.map.sorted.MutableSortedMap;
import org.eclipse.collections.api.multimap.MutableMultimap;
import org.eclipse.collections.api.multimap.bag.MutableBagMultimap;
import org.eclipse.collections.api.partition.bag.PartitionMutableBag;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.set.primitive.MutableCharSet;
import org.eclipse.collections.api.set.sorted.ImmutableSortedSet;
import org.eclipse.collections.api.set.sorted.MutableSortedSet;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.api.tuple.primitive.CharObjectPair;
import org.eclipse.collections.impl.SynchronizedRichIterable;
import org.eclipse.collections.impl.collection.mutable.CollectionAdapter;
import org.eclipse.collections.impl.collection.mutable.SynchronizedMutableCollection;
import org.eclipse.collections.impl.factory.primitive.CharObjectMaps;
import org.eclipse.collections.impl.map.mutable.primitive.UnmodifiableCharObjectMap;
import org.eclipse.collections.impl.primitive.SynchronizedCharIterable;
import org.eclipse.collections.impl.set.mutable.primitive.SynchronizedCharSet;

public class SynchronizedCharObjectMap<V>
implements MutableCharObjectMap<V>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Object lock;
    private final MutableCharObjectMap<V> map;

    public SynchronizedCharObjectMap(MutableCharObjectMap<V> map) {
        this(map, null);
    }

    public SynchronizedCharObjectMap(MutableCharObjectMap<V> map, Object newLock) {
        if (map == null) {
            throw new IllegalArgumentException("Cannot create a SynchronizedCharObjectMap on a null map");
        }
        this.map = map;
        this.lock = newLock == null ? this : newLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V put(char key, V value) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.map.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V putPair(CharObjectPair<V> keyValuePair) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.map.put(keyValuePair.getOne(), keyValuePair.getTwo());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(CharObjectMap<? extends V> map) {
        Object object = this.lock;
        synchronized (object) {
            map.forEachKeyValue((arg_0, arg_1) -> this.map.put(arg_0, arg_1));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V removeKey(char key) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.map.removeKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(char key) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.map.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getIfAbsentPut(char key, V value) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.map.getIfAbsentPut(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getIfAbsentPut(char key, Function0<? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.map.getIfAbsentPut(key, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getIfAbsentPutWithKey(char key, CharToObjectFunction<? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.map.getIfAbsentPutWithKey(key, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> V getIfAbsentPutWith(char key, Function<? super P, ? extends V> function, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.map.getIfAbsentPutWith(key, function, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V updateValue(char key, Function0<? extends V> factory, Function<? super V, ? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.map.updateValue(key, factory, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> V updateValueWith(char key, Function0<? extends V> factory, Function2<? super V, ? super P, ? extends V> function, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.map.updateValueWith(key, factory, function, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeIf(CharObjectPredicate<? super V> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.removeIf(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(char key) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.map.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getIfAbsent(char key, Function0<? extends V> ifAbsent) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.map.getIfAbsent(key, ifAbsent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(char key) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object value) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.containsValue(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableCharObjectMap<V> tap(Procedure<? super V> procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.map.forEach(procedure);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachValue(Procedure<? super V> procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.map.forEachValue(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachKey(CharProcedure procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.map.forEachKey(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachKeyValue(CharObjectProcedure<? super V> procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.map.forEachKeyValue(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableCharObjectMap<V> select(CharObjectPredicate<? super V> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableCharObjectMap<V> reject(CharObjectPredicate<? super V> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean notEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.notEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getFirst() {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.map.getFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getLast() {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.map.getLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V getOnly() {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.map.getOnly();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object object) {
        Object object2 = this.lock;
        synchronized (object2) {
            return this.map.contains(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAllIterable(Iterable<?> source) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.containsAllIterable(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(Collection<?> source) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.containsAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsNoneIterable(Iterable<?> source) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.containsNoneIterable(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsNone(Collection<?> source) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.containsNone(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAnyIterable(Iterable<?> source) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.containsAnyIterable(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAny(Collection<?> source) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.containsAny(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAllArguments(Object ... elements) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.containsAllArguments(elements);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBag<V> select(Predicate<? super V> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends Collection<V>> R select(Predicate<? super V> predicate, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.map.select(predicate, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> MutableBag<V> selectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.selectWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P, R extends Collection<V>> R selectWith(Predicate2<? super V, ? super P> predicate, P parameter, R targetCollection) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.map.selectWith(predicate, parameter, targetCollection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PartitionMutableBag<V> partition(Predicate<? super V> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.partition(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> PartitionMutableBag<V> partitionWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.partitionWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S> MutableBag<S> selectInstancesOf(Class<S> clazz) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.selectInstancesOf(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public MutableSet<Pair<V, Integer>> zipWithIndex() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.zipWithIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends Collection<Pair<V, Integer>>> R zipWithIndex(R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.map.zipWithIndex(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RichIterable<RichIterable<V>> chunk(int size) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.chunk(size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, VV> MutableMap<K, VV> aggregateInPlaceBy(Function<? super V, ? extends K> groupBy, Function0<? extends VV> zeroValueFactory, Procedure2<? super VV, ? super V> mutatingAggregator) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.aggregateInPlaceBy(groupBy, zeroValueFactory, mutatingAggregator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K, VV> MutableMap<K, VV> aggregateBy(Function<? super V, ? extends K> groupBy, Function0<? extends VV> zeroValueFactory, Function2<? super VV, ? super V, ? extends VV> nonMutatingAggregator) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.aggregateBy(groupBy, zeroValueFactory, nonMutatingAggregator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K> MutableMap<K, V> reduceBy(Function<? super V, ? extends K> groupBy, Function2<? super V, ? super V, ? extends V> reduceFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.reduceBy(groupBy, reduceFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBag<V> reject(Predicate<? super V> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends Collection<V>> R reject(Predicate<? super V> predicate, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.map.reject(predicate, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> MutableBag<V> rejectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.rejectWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P, R extends Collection<V>> R rejectWith(Predicate2<? super V, ? super P> predicate, P parameter, R targetCollection) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.map.rejectWith(predicate, parameter, targetCollection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.map.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <VV> MutableBag<VV> collect(Function<? super V, ? extends VV> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBooleanBag collectBoolean(BooleanFunction<? super V> booleanFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.collectBoolean(booleanFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends MutableBooleanCollection> R collectBoolean(BooleanFunction<? super V> booleanFunction, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.map.collectBoolean(booleanFunction, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableByteBag collectByte(ByteFunction<? super V> byteFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.collectByte(byteFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends MutableByteCollection> R collectByte(ByteFunction<? super V> byteFunction, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.map.collectByte(byteFunction, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableCharBag collectChar(CharFunction<? super V> charFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.collectChar(charFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends MutableCharCollection> R collectChar(CharFunction<? super V> charFunction, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.map.collectChar(charFunction, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableDoubleBag collectDouble(DoubleFunction<? super V> doubleFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.collectDouble(doubleFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends MutableDoubleCollection> R collectDouble(DoubleFunction<? super V> doubleFunction, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.map.collectDouble(doubleFunction, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableFloatBag collectFloat(FloatFunction<? super V> floatFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.collectFloat(floatFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends MutableFloatCollection> R collectFloat(FloatFunction<? super V> floatFunction, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.map.collectFloat(floatFunction, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableIntBag collectInt(IntFunction<? super V> intFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.collectInt(intFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends MutableIntCollection> R collectInt(IntFunction<? super V> intFunction, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.map.collectInt(intFunction, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableLongBag collectLong(LongFunction<? super V> longFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.collectLong(longFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends MutableLongCollection> R collectLong(LongFunction<? super V> longFunction, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.map.collectLong(longFunction, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableShortBag collectShort(ShortFunction<? super V> shortFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.collectShort(shortFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends MutableShortCollection> R collectShort(ShortFunction<? super V> shortFunction, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.map.collectShort(shortFunction, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P, VV> MutableBag<VV> collectWith(Function2<? super V, ? super P, ? extends VV> function, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.collectWith(function, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P, VV, R extends Collection<VV>> R collectWith(Function2<? super V, ? super P, ? extends VV> function, P parameter, R targetCollection) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.map.collectWith(function, parameter, targetCollection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <VV, R extends Collection<VV>> R collect(Function<? super V, ? extends VV> function, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.map.collect(function, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <VV> MutableBag<VV> collectIf(Predicate<? super V> predicate, Function<? super V, ? extends VV> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.collectIf(predicate, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <VV, R extends Collection<VV>> R collectIf(Predicate<? super V> predicate, Function<? super V, ? extends VV> function, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.map.collectIf(predicate, function, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <VV> MutableBag<VV> flatCollect(Function<? super V, ? extends Iterable<VV>> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.flatCollect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <VV, R extends Collection<VV>> R flatCollect(Function<? super V, ? extends Iterable<VV>> function, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.map.flatCollect(function, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends MutableByteCollection> R flatCollectByte(Function<? super V, ? extends ByteIterable> function, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.map.flatCollectByte(function, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends MutableCharCollection> R flatCollectChar(Function<? super V, ? extends CharIterable> function, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.map.flatCollectChar(function, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends MutableIntCollection> R flatCollectInt(Function<? super V, ? extends IntIterable> function, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.map.flatCollectInt(function, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends MutableShortCollection> R flatCollectShort(Function<? super V, ? extends ShortIterable> function, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.map.flatCollectShort(function, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends MutableDoubleCollection> R flatCollectDouble(Function<? super V, ? extends DoubleIterable> function, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.map.flatCollectDouble(function, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends MutableFloatCollection> R flatCollectFloat(Function<? super V, ? extends FloatIterable> function, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.map.flatCollectFloat(function, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends MutableLongCollection> R flatCollectLong(Function<? super V, ? extends LongIterable> function, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.map.flatCollectLong(function, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends MutableBooleanCollection> R flatCollectBoolean(Function<? super V, ? extends BooleanIterable> function, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.map.flatCollectBoolean(function, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V detect(Predicate<? super V> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.map.detect(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> V detectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.map.detectWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<V> detectOptional(Predicate<? super V> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.detectOptional(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> Optional<V> detectWithOptional(Predicate2<? super V, ? super P> predicate, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.detectWithOptional(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V detectIfNone(Predicate<? super V> predicate, Function0<? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.map.detectIfNone(predicate, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> V detectWithIfNone(Predicate2<? super V, ? super P> predicate, P parameter, Function0<? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.map.detectWithIfNone(predicate, parameter, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count(Predicate<? super V> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.count(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> int countWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.countWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean anySatisfy(Predicate<? super V> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.anySatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> boolean anySatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.anySatisfyWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allSatisfy(Predicate<? super V> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.allSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> boolean allSatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.allSatisfyWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean noneSatisfy(Predicate<? super V> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.noneSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> boolean noneSatisfyWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.noneSatisfyWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <IV> IV injectInto(IV injectedValue, Function2<? super IV, ? super V, ? extends IV> function) {
        Object object = this.lock;
        synchronized (object) {
            return (IV)this.map.injectInto(injectedValue, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int injectInto(int injectedValue, IntObjectToIntFunction<? super V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.injectIntoInt(injectedValue, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long injectInto(long injectedValue, LongObjectToLongFunction<? super V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.injectIntoLong(injectedValue, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float injectInto(float injectedValue, FloatObjectToFloatFunction<? super V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.injectIntoFloat(injectedValue, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double injectInto(double injectedValue, DoubleObjectToDoubleFunction<? super V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.injectIntoDouble(injectedValue, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends Collection<V>> R into(R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.map.into(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<V> toList() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<V> toSortedList() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toSortedList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableList<V> toSortedList(Comparator<? super V> comparator) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toSortedList(comparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <VV extends Comparable<? super VV>> MutableList<V> toSortedListBy(Function<? super V, ? extends VV> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toSortedListBy(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSet<V> toSet() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSortedSet<V> toSortedSet() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toSortedSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSortedSet<V> toSortedSet(Comparator<? super V> comparator) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toSortedSet(comparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <VV extends Comparable<? super VV>> MutableSortedSet<V> toSortedSetBy(Function<? super V, ? extends VV> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toSortedSetBy(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBag<V> toBag() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toBag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSortedBag<V> toSortedBag() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toSortedBag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSortedBag<V> toSortedBag(Comparator<? super V> comparator) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toSortedBag(comparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <VV extends Comparable<? super VV>> MutableSortedBag<V> toSortedBagBy(Function<? super V, ? extends VV> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toSortedBagBy(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <NK, NV> MutableMap<NK, NV> toMap(Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toMap(keyFunction, valueFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <NK, NV, R extends Map<NK, NV>> R toMap(Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.map.toMap(keyFunction, valueFunction, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toSortedMap(keyFunction, valueFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <NK, NV> MutableSortedMap<NK, NV> toSortedMap(Comparator<? super NK> comparator, Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toSortedMap(comparator, keyFunction, valueFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <KK extends Comparable<? super KK>, NK, NV> MutableSortedMap<NK, NV> toSortedMapBy(Function<? super NK, KK> sortBy, Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toSortedMapBy(sortBy, keyFunction, valueFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <NK, NV> MutableBiMap<NK, NV> toBiMap(Function<? super V, ? extends NK> keyFunction, Function<? super V, ? extends NV> valueFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toBiMap(keyFunction, valueFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableList<V> toImmutableList() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toImmutableList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableSet<V> toImmutableSet() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toImmutableSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableBag<V> toImmutableBag() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toImmutableBag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableList<V> toImmutableSortedList() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toImmutableSortedList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableList<V> toImmutableSortedList(Comparator<? super V> comparator) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toImmutableSortedList(comparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <VV extends Comparable<? super VV>> ImmutableList<V> toImmutableSortedListBy(Function<? super V, ? extends VV> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toImmutableSortedListBy(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableSortedSet<V> toImmutableSortedSet() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toImmutableSortedSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableSortedSet<V> toImmutableSortedSet(Comparator<? super V> comparator) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toImmutableSortedSet(comparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <VV extends Comparable<? super VV>> ImmutableSortedSet<V> toImmutableSortedSetBy(Function<? super V, ? extends VV> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toImmutableSortedSetBy(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableSortedBag<V> toImmutableSortedBag() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toImmutableSortedBag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableSortedBag<V> toImmutableSortedBag(Comparator<? super V> comparator) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toImmutableSortedBag(comparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <VV extends Comparable<? super VV>> ImmutableSortedBag<V> toImmutableSortedBagBy(Function<? super V, ? extends VV> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toImmutableSortedBagBy(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LazyIterable<V> asLazy() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.asLazy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T[] toArray(T[] a) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toArray((Object[])a);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V min(Comparator<? super V> comparator) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.map.min(comparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V max(Comparator<? super V> comparator) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.map.max(comparator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V min() {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.map.min();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V max() {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.map.max();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <VV extends Comparable<? super VV>> V maxBy(Function<? super V, ? extends VV> function) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.map.maxBy(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <VV extends Comparable<? super VV>> V minBy(Function<? super V, ? extends VV> function) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.map.minBy(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long sumOfInt(IntFunction<? super V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.sumOfInt(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double sumOfFloat(FloatFunction<? super V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.sumOfFloat(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long sumOfLong(LongFunction<? super V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.sumOfLong(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double sumOfDouble(DoubleFunction<? super V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.sumOfDouble(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V1> MutableObjectLongMap<V1> sumByInt(Function<? super V, ? extends V1> groupBy, IntFunction<? super V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.sumByInt(groupBy, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V1> MutableObjectDoubleMap<V1> sumByFloat(Function<? super V, ? extends V1> groupBy, FloatFunction<? super V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.sumByFloat(groupBy, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V1> MutableObjectLongMap<V1> sumByLong(Function<? super V, ? extends V1> groupBy, LongFunction<? super V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.sumByLong(groupBy, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V1> MutableObjectDoubleMap<V1> sumByDouble(Function<? super V, ? extends V1> groupBy, DoubleFunction<? super V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.sumByDouble(groupBy, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableCharSet keySet() {
        Object object = this.lock;
        synchronized (object) {
            return SynchronizedCharSet.of(this.map.keySet(), this.lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<V> values() {
        Object object = this.lock;
        synchronized (object) {
            return SynchronizedMutableCollection.of(CollectionAdapter.adapt(this.map.values()), this.lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LazyCharIterable keysView() {
        Object object = this.lock;
        synchronized (object) {
            return SynchronizedCharIterable.of((CharIterable)this.map.keysView(), this.lock).asLazy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RichIterable<CharObjectPair<V>> keyValuesView() {
        Object object = this.lock;
        synchronized (object) {
            return SynchronizedRichIterable.of(this.map.keyValuesView(), this.lock).asLazy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableObjectCharMap<V> flipUniqueValues() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.flipUniqueValues();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.equals(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.hashCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String makeString() {
        Object object = this.lock;
        synchronized (object) {
            return this.map.makeString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String makeString(String separator) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.makeString(separator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String makeString(String start, String separator, String end) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.makeString(start, separator, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendString(Appendable appendable) {
        Object object = this.lock;
        synchronized (object) {
            this.map.appendString(appendable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendString(Appendable appendable, String separator) {
        Object object = this.lock;
        synchronized (object) {
            this.map.appendString(appendable, separator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendString(Appendable appendable, String start, String separator, String end) {
        Object object = this.lock;
        synchronized (object) {
            this.map.appendString(appendable, start, separator, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <VV> MutableBagMultimap<VV, V> groupBy(Function<? super V, ? extends VV> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.groupBy(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <VV, R extends MutableMultimap<VV, V>> R groupBy(Function<? super V, ? extends VV> function, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.map.groupBy(function, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <VV> MutableBagMultimap<VV, V> groupByEach(Function<? super V, ? extends Iterable<VV>> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.groupByEach(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <VV, R extends MutableMultimap<VV, V>> R groupByEach(Function<? super V, ? extends Iterable<VV>> function, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.map.groupByEach(function, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <VV> MutableMap<VV, V> groupByUniqueKey(Function<? super V, ? extends VV> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.groupByUniqueKey(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <VV, R extends MutableMapIterable<VV, V>> R groupByUniqueKey(Function<? super V, ? extends VV> function, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.map.groupByUniqueKey(function, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public <S> MutableBag<Pair<V, S>> zip(Iterable<S> that) {
        Object object = this.lock;
        synchronized (object) {
            return this.map.zip(that);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S, R extends Collection<Pair<V, S>>> R zip(Iterable<S> that, R target) {
        Object object = this.lock;
        synchronized (object) {
            return (R)this.map.zip(that, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableCharObjectMap<V> withKeyValue(char key, V value) {
        Object object = this.lock;
        synchronized (object) {
            this.map.withKeyValue(key, value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableCharObjectMap<V> withoutKey(char key) {
        Object object = this.lock;
        synchronized (object) {
            this.map.withoutKey(key);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableCharObjectMap<V> withoutAllKeys(CharIterable keys) {
        Object object = this.lock;
        synchronized (object) {
            this.map.withoutAllKeys(keys);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableCharObjectMap<V> asUnmodifiable() {
        Object object = this.lock;
        synchronized (object) {
            return new UnmodifiableCharObjectMap(this);
        }
    }

    public MutableCharObjectMap<V> asSynchronized() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableCharObjectMap<V> toImmutable() {
        Object object = this.lock;
        synchronized (object) {
            return CharObjectMaps.immutable.withAll((CharObjectMap)this);
        }
    }

    public void forEach(Procedure<? super V> procedure) {
        this.each(procedure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void each(Procedure<? super V> procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.map.forEach(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachWithIndex(ObjectIntProcedure<? super V> objectIntProcedure) {
        Object object = this.lock;
        synchronized (object) {
            this.map.forEachWithIndex(objectIntProcedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> void forEachWith(Procedure2<? super V, ? super P> procedure, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            this.map.forEachWith(procedure, parameter);
        }
    }

    public Iterator<V> iterator() {
        return this.map.iterator();
    }
}

