/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.ui.handlers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.OpenStrategy;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.objectteams.otdt.core.ICallinMapping;
import org.eclipse.objectteams.otdt.core.IMethodMapping;
import org.eclipse.objectteams.otdt.core.IRoleType;
import org.eclipse.objectteams.otdt.core.OTModelManager;
import org.eclipse.objectteams.otdt.internal.ui.OTDTUIMessages;
import org.eclipse.objectteams.otdt.internal.ui.compare.CompareBoundMethodsEditorInput;
import org.eclipse.objectteams.otdt.ui.OTDTUIPlugin;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.ui.synchronize.SaveableCompareEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.handlers.HandlerUtil;

public class CompareWithBaseMethodHandler
extends AbstractHandler
implements IStructuredSelection {
    IMethod roleMethod;
    IMethod baseMethod;
    ICallinMapping callinMapping;
    private IStructuredSelection selection;
    private IWorkbenchPage page;

    public boolean isEmpty() {
        return false;
    }

    public List toList() {
        ArrayList<IMethod> result = new ArrayList<IMethod>(2);
        result.add(this.roleMethod);
        result.add(this.baseMethod);
        return result;
    }

    public Object[] toArray() {
        return new Object[]{this.roleMethod, this.baseMethod};
    }

    public int size() {
        return 2;
    }

    public Iterator iterator() {
        return null;
    }

    public Object getFirstElement() {
        return null;
    }

    public void setEnabled(Object evaluationContext) {
        IWorkbenchSite site = (IWorkbenchSite)HandlerUtil.getVariable((Object)evaluationContext, (String)"activeSite");
        if (site == null) {
            return;
        }
        this.page = site.getPage();
        this.roleMethod = null;
        this.callinMapping = null;
        ISelection sel = (ISelection)HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
        if (sel instanceof IStructuredSelection) {
            this.selection = (IStructuredSelection)sel;
            if (this.selection.size() == 1) {
                Object element = this.selection.getFirstElement();
                if (element instanceof IMethod) {
                    IMethod method = (IMethod)element;
                    try {
                        if ((method.getFlags() & Integer.MIN_VALUE) != 0) {
                            this.roleMethod = method;
                            this.setBaseEnabled(true);
                            return;
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                } else if (element instanceof ICallinMapping) {
                    this.callinMapping = (ICallinMapping)element;
                    this.setBaseEnabled(true);
                    return;
                }
            }
        }
        this.setBaseEnabled(false);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        this.baseMethod = null;
        if (this.roleMethod != null && this.callinMapping == null) {
            IType type = (IType)this.roleMethod.getParent();
            IRoleType roleType = (IRoleType)OTModelManager.getOTElement((IType)type);
            IMethodMapping[] iMethodMappingArray = roleType.getMethodMappings(1);
            int n = iMethodMappingArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethodMapping mapping = iMethodMappingArray[n2];
                if (mapping.getRoleMethod().equals(this.roleMethod)) {
                    if (this.callinMapping == null) {
                        this.callinMapping = (ICallinMapping)mapping;
                    } else {
                        MessageDialog.openError(null, (String)OTDTUIMessages.CompareWithBaseMethodAction_errorTitle, (String)OTDTUIMessages.CompareWithBaseMethodAction_ambiguousBindingsError);
                        return null;
                    }
                }
                ++n2;
            }
        }
        if (this.callinMapping != null) {
            IMethod[] baseMethods;
            this.roleMethod = this.callinMapping.getRoleMethod();
            try {
                baseMethods = this.callinMapping.getBoundBaseMethods();
            }
            catch (JavaModelException e) {
                throw new ExecutionException(e.getMessage());
            }
            if (baseMethods.length > 1) {
                MessageDialog.openError(null, (String)OTDTUIMessages.CompareWithBaseMethodAction_errorTitle, (String)OTDTUIMessages.CompareWithBaseMethodAction_multipleBaseMethodsError);
                return null;
            }
            this.baseMethod = baseMethods[0];
        }
        if (this.roleMethod != null && this.baseMethod != null) {
            this.openCompareEditor();
        }
        return null;
    }

    void openCompareEditor() {
        try {
            CompareBoundMethodsEditorInput input = new CompareBoundMethodsEditorInput(this.roleMethod, this.baseMethod, this.page);
            IWorkbenchPage workBenchPage = this.page;
            IEditorPart editor = this.findReusableCompareEditor((CompareEditorInput)input, workBenchPage);
            if (editor != null) {
                IEditorInput otherInput = editor.getEditorInput();
                if (otherInput.equals((Object)input)) {
                    if (OpenStrategy.activateOnOpen()) {
                        workBenchPage.activate((IWorkbenchPart)editor);
                    } else {
                        workBenchPage.bringToTop((IWorkbenchPart)editor);
                    }
                } else {
                    CompareUI.reuseCompareEditor((CompareEditorInput)input, (IReusableEditor)((IReusableEditor)editor));
                    if (OpenStrategy.activateOnOpen()) {
                        workBenchPage.activate((IWorkbenchPart)editor);
                    } else {
                        workBenchPage.bringToTop((IWorkbenchPart)editor);
                    }
                }
            } else {
                CompareUI.openCompareEditor((CompareEditorInput)input, (boolean)OpenStrategy.activateOnOpen());
            }
        }
        catch (CoreException ce) {
            OTDTUIPlugin.log(ce);
        }
    }

    IEditorPart findReusableCompareEditor(CompareEditorInput input, IWorkbenchPage page) {
        IEditorPart part;
        IEditorReference[] editorRefs = page.getEditorReferences();
        int i = 0;
        while (i < editorRefs.length) {
            part = editorRefs[i].getEditor(false);
            if (part != null && part.getEditorInput() instanceof CompareBoundMethodsEditorInput && part instanceof IReusableEditor && part.getEditorInput().equals(input)) {
                return part;
            }
            ++i;
        }
        if (this.isReuseOpenEditor()) {
            i = 0;
            while (i < editorRefs.length) {
                part = editorRefs[i].getEditor(false);
                if (part != null && part.getEditorInput() instanceof SaveableCompareEditorInput && part instanceof IReusableEditor && !part.isDirty()) {
                    return part;
                }
                ++i;
            }
        }
        return null;
    }

    boolean isReuseOpenEditor() {
        return TeamUIPlugin.getPlugin().getPreferenceStore().getBoolean("org.eclipse.team.ui.reuse_open_compare_editors");
    }
}

