/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otre;

import java.util.HashSet;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ACONST_NULL;
import org.apache.bcel.generic.ATHROW;
import org.apache.bcel.generic.BranchInstruction;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.ICONST;
import org.apache.bcel.generic.IFEQ;
import org.apache.bcel.generic.ILOAD;
import org.apache.bcel.generic.ISTORE;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.LocalVariableGen;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NOP;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.Type;
import org.eclipse.objectteams.otre.ClassEnhancer;
import org.eclipse.objectteams.otre.OTConstants;
import org.eclipse.objectteams.otre.ObjectTeamsTransformation;
import org.eclipse.objectteams.otre.RepositoryAccess;
import org.eclipse.objectteams.otre.jplis.JPLISEnhancer;

public class ThreadActivation {
    private static final String CREATION_THREAD = "_OT$creationThread";
    HashSet<String> transformableClasses = new HashSet();

    private boolean shouldTransform(ClassGen cg) {
        Method runMethode = cg.containsMethod("run", "()V");
        if (runMethode == null || runMethode.isAbstract()) {
            return false;
        }
        String class_name = cg.getClassName();
        try {
            return RepositoryAccess.implementationOf(class_name, "java.lang.Runnable") || RepositoryAccess.instanceOf(class_name, "java.lang.Thread");
        }
        catch (ClassNotFoundException cfne) {
            if (ObjectTeamsTransformation.WORKAROUND_REPOSITORY) {
                return false;
            }
            throw new RuntimeException("Could not find class being loaded", cfne);
        }
    }

    public void doTransformInterface(ClassEnhancer enhancer, ClassGen cg) {
        if (!this.shouldTransform(cg)) {
            return;
        }
        if (this.transformableClasses.contains(cg.getClassName())) {
            return;
        }
        this.transformableClasses.add(cg.getClassName());
        FieldGen field = new FieldGen(2, (Type)OTConstants.threadType, CREATION_THREAD, cg.getConstantPool());
        enhancer.addField(field.getField(), cg);
    }

    public void doTransformCode(ClassGen cg) {
        if (!this.transformableClasses.contains(cg.getClassName())) {
            return;
        }
        this.transformableClasses.remove(cg.getClassName());
        InstructionFactory factory = new InstructionFactory(cg);
        Method[] methodArray = cg.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            MethodGen mg = this.isRootCtor(method, cg);
            if (mg != null) {
                this.enhanceConstructor(cg, factory, method, mg);
            }
            ++n2;
        }
        this.enhanceRunMethod(cg, factory);
    }

    private void enhanceRunMethod(ClassGen cg, InstructionFactory factory) {
        String class_name = cg.getClassName();
        ConstantPoolGen cpg = cg.getConstantPool();
        Method runMethode = cg.containsMethod("run", "()V");
        MethodGen mg = ObjectTeamsTransformation.newMethodGen(runMethode, class_name, cpg);
        InstructionList il = mg.getInstructionList();
        InstructionHandle try_start = il.getStart();
        InstructionList threadActivation = new InstructionList();
        threadActivation.append((Instruction)new ICONST(0));
        threadActivation.append((Instruction)InstructionConstants.ALOAD_0);
        threadActivation.append((Instruction)factory.createFieldAccess(class_name, CREATION_THREAD, (Type)OTConstants.threadType, (short)180));
        threadActivation.append((Instruction)factory.createInvoke("org.objectteams.TeamThreadManager", "newThreadStarted", (Type)Type.BOOLEAN, new Type[]{Type.BOOLEAN, OTConstants.threadType}, (short)184));
        LocalVariableGen flag = mg.addLocalVariable("_OT$isThreadStart", (Type)Type.BOOLEAN, il.getStart(), il.getEnd());
        threadActivation.append((Instruction)new ISTORE(flag.getIndex()));
        threadActivation.append((Instruction)InstructionConstants.ALOAD_0);
        threadActivation.append((Instruction)new ACONST_NULL());
        threadActivation.append((Instruction)factory.createFieldAccess(class_name, CREATION_THREAD, (Type)OTConstants.threadType, (short)181));
        il.insert(threadActivation);
        InstructionList threadDeactivation = new InstructionList();
        threadDeactivation.append((Instruction)new ILOAD(flag.getIndex()));
        IFEQ ifIsThreadStarted = new IFEQ(null);
        threadDeactivation.append((BranchInstruction)ifIsThreadStarted);
        threadDeactivation.append((Instruction)factory.createInvoke("org.objectteams.TeamThreadManager", "threadEnded", (Type)Type.VOID, Type.NO_ARGS, (short)184));
        ifIsThreadStarted.setTarget(threadDeactivation.append((Instruction)new NOP()));
        ObjectTeamsTransformation.insertBeforeReturn(mg, il, threadDeactivation);
        ObjectType throwable = new ObjectType("java.lang.Throwable");
        LocalVariableGen exception = mg.addLocalVariable("_OT$thrown_exception", (Type)throwable, null, null);
        InstructionHandle try_end = il.getEnd();
        InstructionList deactivation_ex = threadDeactivation.copy();
        deactivation_ex.insert((Instruction)InstructionFactory.createStore((Type)throwable, (int)exception.getIndex()));
        deactivation_ex.append((Instruction)InstructionFactory.createLoad((Type)throwable, (int)exception.getIndex()));
        deactivation_ex.append((Instruction)new ATHROW());
        InstructionHandle deactivation_handler = il.append(il.getEnd(), deactivation_ex);
        mg.addExceptionHandler(try_start, try_end, deactivation_handler, throwable);
        mg.setMaxStack();
        mg.setMaxLocals();
        Method generatedMethod = mg.getMethod();
        cg.replaceMethod(runMethode, generatedMethod);
        JPLISEnhancer.requireClassFileVersionLessThan51(cg);
        threadActivation.dispose();
        il.dispose();
    }

    private MethodGen isRootCtor(Method method, ClassGen cg) {
        if (!method.getName().equals("<init>")) {
            return null;
        }
        String className = cg.getClassName();
        ConstantPoolGen cpg = cg.getConstantPool();
        MethodGen mg = ObjectTeamsTransformation.newMethodGen(method, className, cpg);
        InstructionList il = mg.getInstructionList();
        InstructionHandle ih = il.getStart();
        while (ih != null && ih.getInstruction().getOpcode() != 183) {
            ih = ih.getNext();
        }
        if (ih == null) {
            return null;
        }
        if (((InvokeInstruction)ih.getInstruction()).getClassName(cpg).equals(className)) {
            return null;
        }
        return mg;
    }

    private void enhanceConstructor(ClassGen cg, InstructionFactory factory, Method initMethod, MethodGen mg) {
        String class_name = cg.getClassName();
        InstructionList il = mg.getInstructionList();
        il.insert(il.getEnd(), (Instruction)InstructionConstants.ALOAD_0);
        il.insert(il.getEnd(), (Instruction)factory.createInvoke("java.lang.Thread", "currentThread", (Type)OTConstants.threadType, new Type[0], (short)184));
        il.insert(il.getEnd(), (Instruction)factory.createFieldAccess(class_name, CREATION_THREAD, (Type)OTConstants.threadType, (short)181));
        mg.setMaxStack();
        mg.setMaxLocals();
        cg.replaceMethod(initMethod, mg.getMethod());
        JPLISEnhancer.requireClassFileVersionLessThan51(cg);
        il.dispose();
    }
}

