/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.ui.callinmarkers;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.objectteams.otdt.core.ext.IMarkableJavaElement;
import org.eclipse.objectteams.otdt.ui.OTDTUIPlugin;

public abstract class CallinMarkerJob
extends Job {
    private final IResource _resource;
    private final IJavaElement _javaElement;

    public CallinMarkerJob(IMarkableJavaElement target) {
        super(OTDTUIPlugin.getResourceString("CallinMarkerJob.job_title"));
        if (target.isBinary()) {
            this._resource = null;
            this._javaElement = target.getJavaElement();
        } else {
            this._resource = target.getResource();
            this._javaElement = null;
        }
        IResource resource = target.getResource();
        if (resource != null) {
            this.setRule(resource.getWorkspace().getRuleFactory().markerRule(resource));
        }
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.updateMarkers(monitor);
        }
        catch (OperationCanceledException ex) {
            return Status.CANCEL_STATUS;
        }
        catch (Exception ex) {
            return OTDTUIPlugin.createErrorStatus("Exception during marker creation.", ex);
        }
        catch (Error error) {
            // empty catch block
        }
        return Status.OK_STATUS;
    }

    protected abstract void updateMarkers(IProgressMonitor var1) throws Exception;

    public final IResource getResource() {
        return this._resource;
    }

    public final IJavaElement getJavaElement() {
        return this._javaElement;
    }
}

