/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.modules;

import java.util.Map;
import javax.xml.bind.PropertyException;
import org.eclipse.om2m.sdt.DataPoint;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.Property;
import org.eclipse.om2m.sdt.datapoints.BooleanDataPoint;
import org.eclipse.om2m.sdt.datapoints.IntegerDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.eclipse.om2m.sdt.home.types.ModuleType;
import org.eclipse.om2m.sdt.home.types.PropertyType;
import org.eclipse.om2m.sdt.types.SimpleType;

public class Battery
extends Module {
    private IntegerDataPoint level;
    private IntegerDataPoint capacity;
    private IntegerDataPoint batteryThreshold;
    private BooleanDataPoint charging;
    private BooleanDataPoint discharging;
    private BooleanDataPoint lowBattery;
    private Property electricEnergy;
    private Property voltage;
    private Property material;

    public Battery(String name, Domain domain, IntegerDataPoint level) {
        super(name, domain, (Identifiers)ModuleType.battery);
        if (level == null || !level.getShortName().equals(DatapointType.level.getShortName())) {
            throw new IllegalArgumentException("Wrong level datapoint: " + level);
        }
        this.level = level;
        this.level.setWritable(false);
        this.level.setDoc("The rounded percentage of the current level of battery in the range of [0, 100]. 0 percentage shall mean no battery remained.");
        this.addDataPoint((DataPoint)this.level);
    }

    public Battery(String name, Domain domain, Map<String, DataPoint> dps) {
        this(name, domain, (IntegerDataPoint)dps.get(DatapointType.level.getShortName()));
        BooleanDataPoint lowBattery;
        BooleanDataPoint discharging;
        BooleanDataPoint charging;
        IntegerDataPoint batteryThreshold;
        IntegerDataPoint capacity = (IntegerDataPoint)dps.get(DatapointType.capacity.getShortName());
        if (capacity != null) {
            this.setCapacity(capacity);
        }
        if ((batteryThreshold = (IntegerDataPoint)dps.get(DatapointType.batteryThreshold.getShortName())) != null) {
            this.setBatteryThreshold(batteryThreshold);
        }
        if ((charging = (BooleanDataPoint)dps.get(DatapointType.charging.getShortName())) != null) {
            this.setCharging(charging);
        }
        if ((discharging = (BooleanDataPoint)dps.get(DatapointType.discharging.getShortName())) != null) {
            this.setDischarging(discharging);
        }
        if ((lowBattery = (BooleanDataPoint)dps.get(DatapointType.lowBattery.getShortName())) != null) {
            this.setLowBattery(lowBattery);
        }
    }

    public float getLevel() throws DataPointException, AccessException {
        return ((Integer)this.level.getValue()).intValue();
    }

    public void setCharging(BooleanDataPoint dp) {
        this.charging = dp;
        this.charging.setOptional(true);
        this.charging.setWritable(false);
        this.charging.setDoc("The status of charging. \"True\" indicates enabled, and \"False\" indicates not enabled.");
        this.addDataPoint((DataPoint)this.charging);
    }

    public boolean getCharging() throws DataPointException, AccessException {
        if (this.charging == null) {
            throw new DataPointException("Not implemented");
        }
        return (Boolean)this.charging.getValue();
    }

    public void setDischarging(BooleanDataPoint dp) {
        this.discharging = dp;
        this.discharging.setOptional(true);
        this.discharging.setWritable(false);
        this.discharging.setDoc("The status of discharging. \"True\" indicates enabled, and \"False\" indicates not enabled");
        this.addDataPoint((DataPoint)this.discharging);
    }

    public boolean getDischarging() throws DataPointException, AccessException {
        if (this.discharging == null) {
            throw new DataPointException("Not implemented");
        }
        return (Boolean)this.discharging.getValue();
    }

    public void setLowBattery(BooleanDataPoint dp) {
        this.lowBattery = dp;
        this.lowBattery.setOptional(true);
        this.lowBattery.setWritable(false);
        this.lowBattery.setDoc("To indicate that the battery is in low charge level.");
        this.addDataPoint((DataPoint)this.lowBattery);
    }

    public boolean getLowBattery() throws DataPointException, AccessException {
        if (this.lowBattery == null) {
            throw new DataPointException("Not implemented");
        }
        return (Boolean)this.lowBattery.getValue();
    }

    public void setCapacity(IntegerDataPoint dp) {
        this.capacity = dp;
        this.capacity.setOptional(true);
        this.capacity.setWritable(false);
        this.capacity.setDoc("The total capacity of battery in mAh.");
        this.addDataPoint((DataPoint)this.capacity);
    }

    public int getCapacity() throws DataPointException, AccessException {
        if (this.capacity == null) {
            throw new DataPointException("Not implemented");
        }
        return (Integer)this.capacity.getValue();
    }

    public void setBatteryThreshold(IntegerDataPoint dp) {
        this.batteryThreshold = dp;
        this.batteryThreshold.setOptional(true);
        this.batteryThreshold.setWritable(true);
        this.batteryThreshold.setDoc("When the battery level is less than batteryThreshold then the lowBattery is true (and optionally to generate an alarm).");
        this.addDataPoint((DataPoint)this.batteryThreshold);
    }

    public int getBatteryThreshold() throws DataPointException, AccessException {
        if (this.batteryThreshold == null) {
            throw new DataPointException("Not implemented");
        }
        return (Integer)this.batteryThreshold.getValue();
    }

    public void setBatteryThreshold(int b) throws DataPointException, AccessException {
        if (this.batteryThreshold == null) {
            throw new DataPointException("Not implemented");
        }
        this.batteryThreshold.setValue((Object)b);
    }

    public void setElectricEnergy(int v) {
        if (this.electricEnergy == null) {
            this.electricEnergy = new Property((Identifiers)PropertyType.electricEnergy);
            this.electricEnergy.setType(SimpleType.Integer);
            this.electricEnergy.setDoc("Rated electric energy");
            this.addProperty(this.electricEnergy);
        }
        this.electricEnergy.setValue(Integer.toString(v));
    }

    public int getElectricEnergy() throws PropertyException {
        if (this.electricEnergy == null) {
            throw new PropertyException("Not implemented");
        }
        return Integer.parseInt(this.electricEnergy.getValue());
    }

    public void setVoltage(int v) {
        if (this.voltage == null) {
            this.voltage = new Property((Identifiers)PropertyType.voltage);
            this.voltage.setType(SimpleType.Integer);
            this.voltage.setDoc("Rated voltage");
            this.addProperty(this.voltage);
        }
        this.voltage.setValue(Integer.toString(v));
    }

    public int getVoltage() throws PropertyException {
        if (this.voltage == null) {
            throw new PropertyException("Not implemented");
        }
        return Integer.parseInt(this.voltage.getValue());
    }

    public void setMaterial(String v) {
        if (this.material == null) {
            this.material = new Property((Identifiers)PropertyType.material);
            this.material.setType(SimpleType.String);
            this.material.setDoc("The material (e.g. lithium ion, nickel and lead) of the cell.");
            this.addProperty(this.material);
        }
        this.material.setValue(v);
    }

    public String getMaterial() throws PropertyException {
        if (this.material == null) {
            throw new PropertyException("Not implemented");
        }
        return this.material.getValue();
    }
}

