/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.persistence.mongodb.resource;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.mongodb.client.model.Filters;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.AeAnncEntity;
import org.eclipse.om2m.commons.entities.AeEntity;
import org.eclipse.om2m.commons.entities.CSEBaseEntity;
import org.eclipse.om2m.commons.entities.ContainerEntity;
import org.eclipse.om2m.commons.entities.ContentInstanceEntity;
import org.eclipse.om2m.commons.entities.DynamicAuthorizationConsultationEntity;
import org.eclipse.om2m.commons.entities.FlexContainerAnncEntity;
import org.eclipse.om2m.commons.entities.FlexContainerEntity;
import org.eclipse.om2m.commons.entities.MgmtObjAnncEntity;
import org.eclipse.om2m.commons.entities.MgmtObjEntity;
import org.eclipse.om2m.commons.entities.NodeAnncEntity;
import org.eclipse.om2m.commons.entities.NodeEntity;
import org.eclipse.om2m.commons.entities.RemoteCSEEntity;
import org.eclipse.om2m.commons.entities.ResourceEntity;
import org.eclipse.om2m.persistence.mongodb.Constants;
import org.eclipse.om2m.persistence.mongodb.DBServiceImpl;

public class MongoChildLoader<T extends ResourceEntity>
implements Constants {
    private static final Log LOGGER = LogFactory.getLog(MongoChildLoader.class);

    public List<? extends ResourceEntity> loadChildren(T t, JsonArray json) {
        LOGGER.debug((Object)(" * IN loadChildren * " + t + " with " + json));
        ArrayList<Object> entities = new ArrayList<Object>();
        for (JsonObject jsonObject : json) {
            Class<?> clazz = this.getEntityClass(jsonObject);
            if (clazz == null) continue;
            String resId = jsonObject.get("ResourceID").getAsString();
            Document doc = (Document)DBServiceImpl.getInstance().getResourceCollection().find(Filters.eq((String)"ResourceID", (Object)resId)).first();
            if (doc == null) continue;
            Iterator it = doc.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                if (!((String)entry.getKey()).startsWith("#")) continue;
                it.remove();
            }
            entities.add(DBServiceImpl.getInstance().getGson().fromJson(doc.toJson(), clazz));
        }
        LOGGER.debug((Object)(" * OUT loadChildren * " + t + " with " + entities));
        return entities;
    }

    private Class<?> getEntityClass(JsonObject jsonObject) {
        BigInteger type = jsonObject.get("ResourceType").getAsBigInteger();
        switch (type.intValue()) {
            case 2: {
                return AeEntity.class;
            }
            case 10002: {
                return AeAnncEntity.class;
            }
            case 1: {
                return AccessControlPolicyEntity.class;
            }
            case 5: {
                return CSEBaseEntity.class;
            }
            case 28: {
                return FlexContainerEntity.class;
            }
            case 10028: {
                return FlexContainerAnncEntity.class;
            }
            case 3: {
                return ContainerEntity.class;
            }
            case 4: {
                return ContentInstanceEntity.class;
            }
            case 16: {
                return RemoteCSEEntity.class;
            }
            case 34: {
                return DynamicAuthorizationConsultationEntity.class;
            }
            case 14: {
                return NodeEntity.class;
            }
            case 10014: {
                return NodeAnncEntity.class;
            }
            case 13: {
                return MgmtObjEntity.create((BigInteger)jsonObject.get("MgmtDefinition").getAsBigInteger()).getClass();
            }
            case 10013: {
                return MgmtObjAnncEntity.create((BigInteger)jsonObject.get("MgmtDefinition").getAsBigInteger()).getClass();
            }
        }
        LOGGER.warn((Object)("Cannot create entity for " + type));
        return null;
    }
}

