/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.persistence.mongodb.util;

import com.mongodb.client.FindIterable;
import com.mongodb.client.model.Filters;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.eclipse.om2m.commons.entities.UriMapperEntity;
import org.eclipse.om2m.commons.resource.FilterCriteria;
import org.eclipse.om2m.persistence.mongodb.Constants;
import org.eclipse.om2m.persistence.mongodb.DBServiceImpl;
import org.eclipse.om2m.persistence.service.util.ComplexFindUtil;

public class ComplexFindUtilImpl
implements ComplexFindUtil,
Constants {
    private static final ComplexFindUtilImpl INSTANCE = new ComplexFindUtilImpl();

    private ComplexFindUtilImpl() {
    }

    public static ComplexFindUtilImpl getInstance() {
        return INSTANCE;
    }

    public List<UriMapperEntity> getChildUrisDis(String rootUri, FilterCriteria filter) {
        ArrayList<UriMapperEntity> uris = new ArrayList<UriMapperEntity>();
        Document rootDocument = (Document)DBServiceImpl.getInstance().getResourceCollection().find(Filters.eq((String)"ResourceID", (Object)rootUri)).first();
        if (rootDocument == null) {
            return uris;
        }
        String hierarchicalUri = rootDocument.getString((Object)"HierarchicalURI");
        if (hierarchicalUri == null) {
            return uris;
        }
        Bson requestFilter = Filters.regex((String)"HierarchicalURI", (Pattern)Pattern.compile(String.valueOf(hierarchicalUri) + "*"));
        if (filter.getResourceType() != null) {
            requestFilter = Filters.and((Bson[])new Bson[]{requestFilter, Filters.eq((String)"ResourceType", (Object)filter.getResourceType().intValue())});
        }
        FindIterable elements = DBServiceImpl.getInstance().getResourceCollection().find(requestFilter);
        for (Document element : elements) {
            UriMapperEntity uriMapperEntity = new UriMapperEntity();
            uriMapperEntity.setHierarchicalUri(element.getString((Object)"HierarchicalURI"));
            uriMapperEntity.setNonHierarchicalUri(element.getString((Object)"ResourceID"));
            uriMapperEntity.setResourceType(element.getInteger((Object)"ResourceType").intValue());
            uris.add(uriMapperEntity);
        }
        return uris;
    }
}

