/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.netatmo.sdt;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.datapoints.FloatDataPoint;
import org.eclipse.om2m.sdt.datapoints.IntegerDataPoint;
import org.eclipse.om2m.sdt.datapoints.StringDataPoint;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.devices.GenericDevice;
import org.eclipse.om2m.sdt.home.devices.WeatherStation;
import org.eclipse.om2m.sdt.home.driver.Utils;
import org.eclipse.om2m.sdt.home.modules.AcousticSensor;
import org.eclipse.om2m.sdt.home.modules.AirQualitySensor;
import org.eclipse.om2m.sdt.home.modules.Barometer;
import org.eclipse.om2m.sdt.home.modules.Temperature;
import org.eclipse.om2m.sdt.home.netatmo.impl.Activator;
import org.eclipse.om2m.sdt.home.netatmo.model.WeatherStationModule;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public class SDTWeatherStation
extends WeatherStation {
    private List<ServiceRegistration> serviceRegistrations;
    private final WeatherStationModule stationOrModule;

    public SDTWeatherStation(WeatherStationModule pStationOrModule) {
        super(SDTWeatherStation.computeId(pStationOrModule.getName()), pStationOrModule.getId(), Activator.NETATMO_DOMAIN);
        this.stationOrModule = pStationOrModule;
        this.setDeviceManufacturer("Netatmo");
        this.setDeviceModelName("WeatherStation");
        this.setDeviceName(pStationOrModule.getName());
        this.setProtocol("Netatmo");
        try {
            this.setPresentationURL(new URL("https://www.netatmo.com/product/weather/weatherstation"));
        }
        catch (MalformedURLException malformedURLException) {}
        if (this.stationOrModule.getDataTypes().contains("Temperature")) {
            this.setIndoorTemperature(new Temperature("temperature_" + this.getId(), Activator.NETATMO_DOMAIN, new FloatDataPoint((Identifiers)DatapointType.currentTemperature){

                protected Float doGetValue() throws DataPointException {
                    return Float.valueOf(new Double(SDTWeatherStation.this.stationOrModule.getCurrentTemperature()).floatValue());
                }
            }));
            this.getIndoorTemperature().setMinValue(new FloatDataPoint((Identifiers)DatapointType.minValue){

                protected Float doGetValue() throws DataPointException {
                    return Float.valueOf(new Double(SDTWeatherStation.this.stationOrModule.getMinTemperature()).floatValue());
                }
            });
            this.getIndoorTemperature().setMaxValue(new FloatDataPoint((Identifiers)DatapointType.maxValue){

                protected Float doGetValue() throws DataPointException {
                    return Float.valueOf(new Double(SDTWeatherStation.this.stationOrModule.getMaxTemperature()).floatValue());
                }
            });
            this.getIndoorTemperature().setUnit(new StringDataPoint((Identifiers)DatapointType.unit){

                protected String doGetValue() throws DataPointException {
                    return "\u00b0C";
                }
            });
        }
        if (this.stationOrModule.getDataTypes().contains("Noise")) {
            this.setAcousticSensor(new AcousticSensor("noise_" + this.getId(), Activator.NETATMO_DOMAIN, new FloatDataPoint((Identifiers)DatapointType.loudness){

                protected Float doGetValue() throws DataPointException {
                    return Float.valueOf(SDTWeatherStation.this.stationOrModule.getNoise());
                }
            }));
        }
        if (this.stationOrModule.getDataTypes().contains("Pressure")) {
            this.setBarometer(new Barometer("atmosphericPressureSensor_" + this.getId(), Activator.NETATMO_DOMAIN, new FloatDataPoint((Identifiers)DatapointType.atmosphericPressure){

                protected Float doGetValue() throws DataPointException {
                    return Float.valueOf(new Double(SDTWeatherStation.this.stationOrModule.getAbsolutePressure()).floatValue());
                }
            }));
        }
        AirQualitySensor airQuality = new AirQualitySensor("airQuality_" + this.getId(), Activator.NETATMO_DOMAIN);
        this.setAirQualitySensor(airQuality);
        if (this.stationOrModule.getDataTypes().contains("Humidity")) {
            airQuality.setSensorHumidity(new IntegerDataPoint((Identifiers)DatapointType.sensorHumidity){

                protected Integer doGetValue() throws DataPointException {
                    return (int)SDTWeatherStation.this.stationOrModule.getHumidity();
                }
            });
        }
        if (this.stationOrModule.getDataTypes().contains("CO2")) {
            airQuality.setCo2(new IntegerDataPoint((Identifiers)DatapointType.co2){

                protected Integer doGetValue() throws DataPointException {
                    return (int)SDTWeatherStation.this.stationOrModule.getCo2();
                }
            });
        }
    }

    public void register(BundleContext bundleContext) {
        this.serviceRegistrations = Utils.register((GenericDevice)this, (BundleContext)bundleContext);
    }

    public void unregister() {
        for (ServiceRegistration sr : this.serviceRegistrations) {
            sr.unregister();
        }
        Activator.NETATMO_DOMAIN.removeDevice(this.getName());
    }

    private static String computeId(String pId) {
        return pId.replaceAll("[^a-zA-Z0-9]+", "_").trim();
    }
}

