/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.persistence.eclipselink.internal.dao;

import java.math.BigInteger;
import org.eclipse.om2m.commons.constants.MgmtDefinitionTypes;
import org.eclipse.om2m.commons.entities.AreaNwkDeviceInfoEntity;
import org.eclipse.om2m.commons.entities.AreaNwkInfoEntity;
import org.eclipse.om2m.commons.entities.DeviceInfoEntity;
import org.eclipse.om2m.commons.entities.MgmtObjEntity;
import org.eclipse.om2m.persistence.eclipselink.internal.DBTransactionJPAImpl;
import org.eclipse.om2m.persistence.eclipselink.internal.dao.AbstractDAO;
import org.eclipse.om2m.persistence.service.DBTransaction;

public class MgmtObjDAO
extends AbstractDAO<MgmtObjEntity> {
    private AbstractDAO<DeviceInfoEntity> deviceInfoDAO = new AbstractDAO<DeviceInfoEntity>(){

        @Override
        public DeviceInfoEntity find(DBTransaction dbTransaction, Object id) {
            DBTransactionJPAImpl transaction = (DBTransactionJPAImpl)dbTransaction;
            return (DeviceInfoEntity)transaction.getEm().find(DeviceInfoEntity.class, id);
        }

        @Override
        public void delete(DBTransaction dbTransaction, DeviceInfoEntity resource) {
        }
    };
    private AbstractDAO<AreaNwkInfoEntity> areaNwkInfoDAO = new AbstractDAO<AreaNwkInfoEntity>(){

        @Override
        public AreaNwkInfoEntity find(DBTransaction dbTransaction, Object id) {
            DBTransactionJPAImpl transaction = (DBTransactionJPAImpl)dbTransaction;
            return (AreaNwkInfoEntity)transaction.getEm().find(AreaNwkInfoEntity.class, id);
        }

        @Override
        public void delete(DBTransaction dbTransaction, AreaNwkInfoEntity resource) {
        }
    };
    private AbstractDAO<AreaNwkDeviceInfoEntity> areaNwkDeviceInfoDAO = new AbstractDAO<AreaNwkDeviceInfoEntity>(){

        @Override
        public AreaNwkDeviceInfoEntity find(DBTransaction dbTransaction, Object id) {
            DBTransactionJPAImpl transaction = (DBTransactionJPAImpl)dbTransaction;
            return (AreaNwkDeviceInfoEntity)transaction.getEm().find(AreaNwkDeviceInfoEntity.class, id);
        }

        @Override
        public void delete(DBTransaction dbTransaction, AreaNwkDeviceInfoEntity resource) {
        }
    };

    @Override
    public void create(DBTransaction dbTransaction, MgmtObjEntity resource) {
        BigInteger mgd = resource.getMgmtDefinition();
        if (mgd.equals(MgmtDefinitionTypes.AREA_NWK_INFO)) {
            this.areaNwkInfoDAO.create(dbTransaction, (AreaNwkInfoEntity)resource);
        } else if (mgd.equals(MgmtDefinitionTypes.AREA_NWK_DEVICE_INFO)) {
            this.areaNwkDeviceInfoDAO.create(dbTransaction, (AreaNwkDeviceInfoEntity)resource);
        } else if (mgd.equals(MgmtDefinitionTypes.DEVICE_INFO)) {
            this.deviceInfoDAO.create(dbTransaction, (DeviceInfoEntity)resource);
        } else {
            throw new UnsupportedOperationException("Not implemented");
        }
    }

    @Override
    public MgmtObjEntity find(DBTransaction dbTransaction, Object id) {
        MgmtObjEntity ret = (MgmtObjEntity)this.deviceInfoDAO.find(dbTransaction, id);
        if (ret != null) {
            return ret;
        }
        ret = (MgmtObjEntity)this.areaNwkInfoDAO.find(dbTransaction, id);
        if (ret != null) {
            return ret;
        }
        ret = (MgmtObjEntity)this.areaNwkDeviceInfoDAO.find(dbTransaction, id);
        if (ret != null) {
            return ret;
        }
        return null;
    }

    @Override
    public void delete(DBTransaction dbTransaction, MgmtObjEntity resource) {
        DBTransactionJPAImpl transaction = (DBTransactionJPAImpl)dbTransaction;
        if (resource.getParentNode() != null) {
            resource.getParentNode().removeMgmtObj(resource);
        }
        transaction.getEm().remove((Object)resource);
    }
}

