/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.datapoints;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.datapoints.ValuedDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.types.DataType;

public abstract class EnumDataPoint<T>
extends ValuedDataPoint<T> {
    private static final Identifiers anon = new Identifiers(){

        @Override
        public String getShortName() {
            return "enum";
        }

        @Override
        public String getLongName() {
            return "enumDataPoint";
        }

        @Override
        public String getDefinition() {
            return "enum";
        }
    };
    private List<T> values = new ArrayList<T>();

    public EnumDataPoint(Identifiers name) {
        this(name, DataType.Enum);
    }

    public EnumDataPoint(Identifiers name, DataType type) {
        super(name == null ? anon : name, type);
    }

    @Override
    public void setValue(T v) throws DataPointException, AccessException {
        if (!this.values.contains(v)) {
            throw new DataPointException("Invalid value " + v);
        }
        super.setValue(v);
    }

    public void setValidValues(T[] v) {
        this.values = Arrays.asList(v);
    }

    public void setValidValues(Collection<T> v) {
        this.values.clear();
        this.values.addAll(v);
    }

    public List<T> getValidValues() {
        return this.values;
    }
}

