/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipe.sdt;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.AbstractFlexContainer;
import org.eclipse.om2m.commons.resource.CustomAttribute;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.flexcontainerspec.FlexContainerFactory;
import org.eclipse.om2m.ipe.sdt.CseUtil;
import org.eclipse.om2m.ipe.sdt.flexcontainerservice.ActionFlexContainerService;
import org.eclipse.om2m.sdt.Action;
import org.eclipse.om2m.sdt.Arg;
import org.eclipse.om2m.sdt.Module;

public class SDTActionAdaptor {
    private static Log logger = LogFactory.getLog(SDTActionAdaptor.class);
    private static final String SEP = "/";
    private final boolean hasToBeAnnounced;
    private final String parentLocation;
    private final String resourceLocation;
    private final String resourceName;
    private final Action action;
    private final Module module;
    private final String announceCseId;
    private ActionFlexContainerService actionFlexContainerService;

    public SDTActionAdaptor(Action pAction, String pParentLocation, Module pModule, String announceCseId, boolean hasToBeAnnounced) {
        this.hasToBeAnnounced = hasToBeAnnounced;
        this.action = pAction;
        this.parentLocation = pParentLocation;
        this.resourceName = this.action.getName();
        this.resourceLocation = String.valueOf(this.parentLocation) + SEP + this.resourceName;
        this.module = pModule;
        this.announceCseId = announceCseId;
    }

    public boolean publishActionIntoOM2MTree() {
        logger.info((Object)("publishActionFromOM2MTree(name=" + this.action.getName() + ", location=" + this.resourceLocation + ")"));
        AbstractFlexContainer actionFlexContainer = FlexContainerFactory.getSpecializationFlexContainer((String)this.action.getShortDefinitionName());
        actionFlexContainer.setName(this.resourceName);
        actionFlexContainer.setContainerDefinition(this.action.getDefinition());
        actionFlexContainer.setLongName(this.action.getLongDefinitionName());
        actionFlexContainer.setShortName(this.action.getShortDefinitionName());
        if (this.hasToBeAnnounced) {
            actionFlexContainer.getAnnounceTo().add(SEP + this.announceCseId);
        }
        actionFlexContainer.getLabels().add("pid/" + this.module.getPid());
        actionFlexContainer.getLabels().add("object.type/action");
        actionFlexContainer.getLabels().add("OTB.CATEGORY/Run");
        for (Arg arg : this.action.getArgs()) {
            CustomAttribute customAttribute = new CustomAttribute();
            customAttribute.setShortName(arg.getName());
            actionFlexContainer.getCustomAttributes().add(customAttribute);
        }
        ResponsePrimitive response = CseUtil.sendCreateFlexContainerRequest(actionFlexContainer, this.parentLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            logger.error((Object)("unable to create a FlexContainer for action " + this.action.getName() + ":" + response.getContent()), null);
            return false;
        }
        AbstractFlexContainer createdFlexContainer = (AbstractFlexContainer)response.getContent();
        this.actionFlexContainerService = new ActionFlexContainerService(this.action, createdFlexContainer.getResourceID());
        this.actionFlexContainerService.register();
        logger.debug((Object)("publishActionFromOM2MTree(name=" + this.action.getName() + ", location=" + this.resourceLocation + ") - OK"));
        return true;
    }

    public void unpublishActionFromOM2MTree() {
        logger.info((Object)("unpublishActionFromOM2MTree(name=" + this.action.getName() + ", location=" + this.resourceLocation + ")"));
        CseUtil.sendDeleteRequest(this.resourceLocation);
    }
}

