/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.hue.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.hue.api.HueBridgeDevice;
import org.eclipse.om2m.hue.api.HueLightDevice;
import org.eclipse.om2m.hue.api.types.LightState;
import org.eclipse.om2m.hue.impl.HueDeviceImpl;
import org.eclipse.om2m.hue.impl.controller.Light;

public class HueLightDeviceImpl
extends HueDeviceImpl
implements HueLightDevice {
    private static Log Logger = LogFactory.getLog(HueLightDeviceImpl.class);
    private Light light;
    private HueBridgeDevice bridge;

    public HueLightDeviceImpl(HueBridgeDevice bridge, Light light) {
        super(bridge.getXmlDescription());
        this.light = light;
        this.bridge = bridge;
        this.properties.put("service.pid", bridge.getProperties().get("service.pid") + "_" + light.getId());
        this.properties.put("DEVICE_SERIAL", this.getProperties().get("UPnP.device.serialNumber") + "_" + light.getId());
        this.properties.put("DEVICE_DESCRIPTION", light.getType());
        String manuf = (String)bridge.getProperties().get("DEVICE_MANUFACTURER");
        this.properties.put("DEVICE_MANUFACTURER", manuf == null ? "" : manuf);
        this.properties.put("DEVICE_FRIENDLY_NAME", light.getName());
        this.properties.put("export.api.Read", "getId,getName,isReachable,isOn");
        this.properties.put("export.api.Action", "setState");
    }

    public String getId() {
        return this.light.getId();
    }

    public String getName() {
        return this.light.getName();
    }

    public boolean isReachable() {
        return this.light.isReachable();
    }

    public LightState getState() {
        try {
            return this.light.getState();
        }
        catch (Exception e) {
            Logger.warn((Object)"", (Throwable)e);
            return null;
        }
    }

    public void setState(LightState state) {
        try {
            this.light.setState(state);
        }
        catch (Exception e) {
            Logger.warn((Object)"", (Throwable)e);
        }
    }

    public void setState(boolean on, int brightness, int saturation, int hue, int effect, int alert) {
        LightState state = new LightState(on);
        state.setAlert(alert);
        state.setBri(brightness);
        state.setEffect(effect);
        state.setHue(hue);
        state.setSat(saturation);
        this.setState(state);
    }

    public boolean isOn() {
        try {
            return this.light.getState().isOn();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public HueBridgeDevice getBridge() {
        return this.bridge;
    }
}

