/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.entitymapper;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.om2m.commons.constants.ResultContent;
import org.eclipse.om2m.commons.entities.AnnouncedResourceEntity;
import org.eclipse.om2m.commons.entities.MgmtObjAnncEntity;
import org.eclipse.om2m.commons.entities.NodeAnncEntity;
import org.eclipse.om2m.commons.entities.SubscriptionEntity;
import org.eclipse.om2m.commons.resource.AnnouncedMgmtResource;
import org.eclipse.om2m.commons.resource.AnnouncedResource;
import org.eclipse.om2m.commons.resource.ChildResourceRef;
import org.eclipse.om2m.commons.resource.NodeAnnc;
import org.eclipse.om2m.commons.resource.Subscription;
import org.eclipse.om2m.core.entitymapper.EntityMapper;
import org.eclipse.om2m.core.entitymapper.EntityMapperFactory;
import org.eclipse.om2m.core.entitymapper.MgmtObjAnncMapper;
import org.eclipse.om2m.core.entitymapper.SubscriptionMapper;

public class NodeAnncMapper
extends EntityMapper<NodeAnncEntity, NodeAnnc> {
    private MgmtObjAnncMapper mgmtObjMapper = new MgmtObjAnncMapper();

    @Override
    protected void mapAttributes(NodeAnncEntity entity, NodeAnnc resource, int level, int offset) {
        if (level < 0) {
            return;
        }
        EntityMapperFactory.getAnnouncedResourceMapper().mapAttributes((AnnouncedResourceEntity)entity, (AnnouncedResource)resource, level, offset);
        resource.setNodeID(entity.getNodeID());
        resource.setHostedCSELink(entity.getHostedCSELink());
        resource.setHostedServiceLinks(entity.getHostedServiceLinks());
    }

    @Override
    protected List<ChildResourceRef> getChildResourceRef(NodeAnncEntity entity, int level, int offset) {
        ArrayList<ChildResourceRef> childRefs = new ArrayList<ChildResourceRef>();
        if (level == 0) {
            return childRefs;
        }
        for (SubscriptionEntity sub : entity.getChildSubscriptions()) {
            ChildResourceRef child = new ChildResourceRef();
            child.setResourceName(sub.getName());
            child.setType(23);
            child.setValue(sub.getResourceID());
            childRefs.add(child);
            childRefs.addAll(new SubscriptionMapper().getChildResourceRef(sub, level - 1, offset - 1));
        }
        for (MgmtObjAnncEntity mgmtObj : entity.getMgmtObjEntities()) {
            childRefs.add(this.createChildResourceRef(mgmtObj));
            childRefs.addAll(this.mgmtObjMapper.getChildResourceRef(mgmtObj, level - 1, offset - 1));
        }
        return childRefs;
    }

    @Override
    protected void mapChildResourceRef(NodeAnncEntity entity, NodeAnnc resource, int level, int offset) {
        resource.getChildResource().addAll(this.getChildResourceRef(entity, level, offset));
    }

    @Override
    protected void mapChildResources(NodeAnncEntity entity, NodeAnnc resource, int level, int offset) {
        for (SubscriptionEntity sub : entity.getChildSubscriptions()) {
            Subscription cfr_ignored_0 = (Subscription)new SubscriptionMapper().mapEntityToResource(sub, ResultContent.ATTRIBUTES, level - 1, offset - 1);
        }
        for (MgmtObjAnncEntity mgmtObj : entity.getMgmtObjEntities()) {
            resource.getMgmtObjs().add((AnnouncedMgmtResource)this.mgmtObjMapper.mapEntityToResource(mgmtObj, ResultContent.ATTRIBUTES, level - 1, offset - 1));
        }
    }

    @Override
    protected NodeAnnc createResource() {
        return new NodeAnnc();
    }

    private final ChildResourceRef createChildResourceRef(MgmtObjAnncEntity entity) {
        ChildResourceRef chref = new ChildResourceRef();
        chref.setResourceName(entity.getName());
        chref.setType(10013);
        chref.setValue(entity.getResourceID());
        return chref;
    }
}

