/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.devices;

import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.Property;
import org.eclipse.om2m.sdt.home.devices.GenericDevice;
import org.eclipse.om2m.sdt.home.modules.BinarySwitch;
import org.eclipse.om2m.sdt.home.modules.Clock;
import org.eclipse.om2m.sdt.home.modules.EnergyConsumption;
import org.eclipse.om2m.sdt.home.modules.EnergyGeneration;
import org.eclipse.om2m.sdt.home.modules.FaultDetection;
import org.eclipse.om2m.sdt.home.modules.RunState;
import org.eclipse.om2m.sdt.home.types.DeviceType;
import org.eclipse.om2m.sdt.home.types.PropertyType;
import org.eclipse.om2m.sdt.types.SimpleType;

public class SmartElectricMeter
extends GenericDevice {
    private BinarySwitch binarySwitch;
    private EnergyConsumption energyConsumption;
    private FaultDetection faultDetection;
    private RunState runState;
    private Clock clock;
    private EnergyGeneration generationMeter;
    private Property measuringScope = new Property((Identifiers)PropertyType.measuringScope);

    public SmartElectricMeter(String id, String serial, Domain domain) {
        super(id, serial, DeviceType.deviceSmartElectricMeter, domain);
        this.measuringScope.setType(SimpleType.String);
        this.measuringScope.setOptional(true);
        this.measuringScope.setDoc("Measuring scope of the meter (ex. Whole house, room, or device)");
        this.addProperty(this.measuringScope);
    }

    public void addModule(Module module) {
        if (module instanceof FaultDetection) {
            this.addModule((FaultDetection)module);
        } else if (module instanceof EnergyConsumption) {
            this.addModule((EnergyConsumption)module);
        } else if (module instanceof BinarySwitch) {
            this.addModule((BinarySwitch)module);
        } else if (module instanceof RunState) {
            this.addModule((RunState)module);
        } else if (module instanceof Clock) {
            this.addModule((Clock)module);
        } else if (module instanceof EnergyGeneration) {
            this.addModule((EnergyGeneration)module);
        } else {
            super.addModule(module);
        }
    }

    public void addModule(BinarySwitch binarySwitch) {
        this.binarySwitch = binarySwitch;
        super.addModule((Module)binarySwitch);
    }

    public void addModule(EnergyConsumption energyConsumption) {
        this.energyConsumption = energyConsumption;
        super.addModule((Module)energyConsumption);
    }

    public void addModule(FaultDetection faultDetection) {
        this.faultDetection = faultDetection;
        super.addModule((Module)faultDetection);
    }

    public void addModule(RunState runState) {
        this.runState = runState;
        super.addModule((Module)runState);
    }

    public void addModule(Clock clock) {
        this.clock = clock;
        super.addModule((Module)clock);
    }

    public void addModule(EnergyGeneration generationMeter) {
        this.generationMeter = generationMeter;
        super.addModule((Module)generationMeter);
    }

    public EnergyConsumption getEnergyConsumption() {
        return this.energyConsumption;
    }

    public FaultDetection getFaultDetection() {
        return this.faultDetection;
    }

    public BinarySwitch getBinarySwitch() {
        return this.binarySwitch;
    }

    public RunState getRunState() {
        return this.runState;
    }

    public Clock getClock() {
        return this.clock;
    }

    public EnergyGeneration getGenerationMeter() {
        return this.generationMeter;
    }
}

