/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.modules;

import java.net.URI;
import java.util.Map;
import org.eclipse.om2m.sdt.DataPoint;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.datapoints.StringDataPoint;
import org.eclipse.om2m.sdt.datapoints.UriDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.eclipse.om2m.sdt.home.types.ModuleType;

public class SessionDescription
extends Module {
    private UriDataPoint url;
    private StringDataPoint sdp;

    public SessionDescription(String name, Domain domain) {
        super(name, domain, (Identifiers)ModuleType.sessionDescription);
    }

    public SessionDescription(String name, Domain domain, Map<String, DataPoint> dps) {
        this(name, domain);
        StringDataPoint sdp;
        UriDataPoint url = (UriDataPoint)dps.get(DatapointType.url.getShortName());
        if (url != null) {
            this.setUrl(url);
        }
        if ((sdp = (StringDataPoint)dps.get(DatapointType.sdp.getShortName())) != null) {
            this.setSdp(sdp);
        }
    }

    public void setUrl(UriDataPoint dp) {
        this.url = dp;
        this.url.setOptional(true);
        this.url.setWritable(false);
        this.url.setDoc("A URL at which the specified media can be accessed.");
        this.addDataPoint((DataPoint)this.url);
    }

    public URI getUrl() throws DataPointException, AccessException {
        if (this.url == null) {
            throw new DataPointException("Not implemented");
        }
        return (URI)this.url.getValue();
    }

    public void setSdp(StringDataPoint dp) {
        this.sdp = dp;
        this.sdp.setOptional(true);
        this.sdp.setWritable(false);
        this.sdp.setDoc("Media description using SDP. One or more comma separated multiple SDP lines (SDP media or attribute line) can be included using SDP description syntax as defined in the SDP specification in RFC4566.");
        this.addDataPoint((DataPoint)this.sdp);
    }

    public String getSdp() throws DataPointException, AccessException {
        if (this.sdp == null) {
            throw new DataPointException("Not implemented");
        }
        return (String)this.sdp.getValue();
    }
}

