/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.dynamicauthorization;

import java.math.BigInteger;
import java.util.List;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.Operation;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.constants.SecurityInfoType;
import org.eclipse.om2m.commons.entities.DynamicAuthorizationConsultationEntity;
import org.eclipse.om2m.commons.entities.ResourceEntity;
import org.eclipse.om2m.commons.exceptions.AccessDeniedException;
import org.eclipse.om2m.commons.resource.AccessControlRule;
import org.eclipse.om2m.commons.resource.DynAuthDasRequest;
import org.eclipse.om2m.commons.resource.DynAuthDasResponse;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.SecurityInfo;
import org.eclipse.om2m.commons.resource.SetOfAcrs;
import org.eclipse.om2m.core.redirector.Redirector;

public class DynamicAuthorizationSelector {
    private static final DynamicAuthorizationSelector INSTANCE = new DynamicAuthorizationSelector();

    public static DynamicAuthorizationSelector getInstance() {
        return INSTANCE;
    }

    private DynamicAuthorizationSelector() {
    }

    public void authorize(List<DynamicAuthorizationConsultationEntity> dacesToBeUsed, RequestPrimitive request, ResourceEntity resourceEntity) throws AccessDeniedException {
        for (DynamicAuthorizationConsultationEntity dace : dacesToBeUsed) {
            if (!dace.getDynamicAuthorizationEnabled().booleanValue() || !this.authorize(dace, request, resourceEntity)) continue;
            return;
        }
        throw new AccessDeniedException();
    }

    private boolean authorize(DynamicAuthorizationConsultationEntity dace, RequestPrimitive request, ResourceEntity resourceEntity) {
        SecurityInfo securityInfo = new SecurityInfo();
        securityInfo.setSecurityInfoType(SecurityInfoType.DYNAMIC_AUTHORIZATION_REQUEST);
        securityInfo.setDasRequest(new DynAuthDasRequest());
        securityInfo.getDasRequest().setOperation(request.getOperation());
        securityInfo.getDasRequest().setOriginator(request.getFrom());
        securityInfo.getDasRequest().setTargetedResourceID(resourceEntity.getResourceID());
        securityInfo.getDasRequest().setTargetedResourceType(resourceEntity.getResourceType());
        List pointOfAccesses = dace.getDynamicAuthorizationPoA();
        for (String pointOfAccess : pointOfAccesses) {
            DynAuthDasResponse.DynamicACPInfo dynamicAcpInfo;
            SecurityInfo responseSecurityInfo;
            RequestPrimitive notifyRequest = new RequestPrimitive();
            notifyRequest.setOperation(Operation.NOTIFY);
            notifyRequest.setTo(pointOfAccess);
            notifyRequest.setFrom(Constants.ADMIN_REQUESTING_ENTITY);
            notifyRequest.setContent((Object)securityInfo);
            notifyRequest.setRequestContentType("application/obj");
            notifyRequest.setReturnContentType("application/obj");
            ResponsePrimitive response = Redirector.retargetNotify(notifyRequest);
            if (!ResponseStatusCode.OK.equals(response.getResponseStatusCode()) || (responseSecurityInfo = (SecurityInfo)response.getContent()) == null || !SecurityInfoType.DYNAMIC_AUTHORIZATION_RESPONSE.equals(responseSecurityInfo.getSecurityInfoType()) || (dynamicAcpInfo = responseSecurityInfo.getDasResponse().getDynamicACPInfo()) == null) continue;
            try {
                this.checkACPs(dynamicAcpInfo, request.getFrom(), request.getOperation());
                return true;
            }
            catch (AccessDeniedException accessDeniedException) {}
        }
        return false;
    }

    public void checkACPs(DynAuthDasResponse.DynamicACPInfo dynamicAcpInfo, String originator, BigInteger operation) throws AccessDeniedException {
        if (originator == null) {
            throw new AccessDeniedException();
        }
        if (dynamicAcpInfo == null) {
            throw new AccessDeniedException("dynamicAcpInfo is false");
        }
        boolean originatorFound = false;
        boolean operationAllowed = false;
        SetOfAcrs setOfAcrs = dynamicAcpInfo.getGrantedPrivileges();
        if (setOfAcrs == null) {
            throw new AccessDeniedException("set of acrs is null");
        }
        for (AccessControlRule rule : setOfAcrs.getAccessControlRule()) {
            originatorFound = false;
            operationAllowed = false;
            for (String originatorRule : rule.getAccessControlOriginators()) {
                if (!originator.matches(originatorRule.replace("*", ".*"))) continue;
                originatorFound = true;
                break;
            }
            if (originatorFound && rule.getAccessControlOperations().equals(operation)) {
                operationAllowed = true;
            }
            if (originatorFound && operationAllowed) break;
        }
        if (originatorFound && operationAllowed) {
            return;
        }
        throw new AccessDeniedException();
    }
}

