/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.userstorage.util;

import java.util.regex.Pattern;

public final class BadApplicationTokenException
extends RuntimeException {
    private static final int MIN_CHARS = 5;
    private static final int MAX_CHARS = 27;
    private static final Pattern PATTERN = Pattern.compile("[a-zA-Z][a-zA-z0-9_]*");
    private static final long serialVersionUID = 1L;

    public BadApplicationTokenException() {
    }

    private BadApplicationTokenException(String message) {
        super(message);
    }

    public static String validate(String applicationToken) throws BadApplicationTokenException {
        if (applicationToken == null) {
            throw new BadApplicationTokenException("Application token is null");
        }
        int length = applicationToken.length();
        if (length < 5) {
            throw new BadApplicationTokenException("Application token is shorter than the minimum of 5 characters");
        }
        if (length > 27) {
            throw new BadApplicationTokenException("Application token is longer than the maximum of 27 characters");
        }
        if (!PATTERN.matcher(applicationToken).matches()) {
            throw new BadApplicationTokenException("Application token '" + applicationToken + "' does not match pattern " + PATTERN);
        }
        return applicationToken;
    }
}

