/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.OomphPlugin;
import org.eclipse.oomph.util.StringUtil;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsNull;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.TestName;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public abstract class AbstractTest
extends CoreMatchers {
    private static final String[] FILTERS = new String[]{"org.eclipse.jdt.internal.junit.runner.", "org.eclipse.jdt.internal.junit.ui.", "org.eclipse.jdt.internal.junit4.runner.", "org.junit.", "sun.reflect.", "java.lang.reflect.Method.invoke(", "junit.framework.Assert", "junit.framework.TestCase", "junit.framework.TestResult", "junit.framework.TestResult$1", "junit.framework.TestSuite"};
    private static final List<File> TEMP_FOLDERS = new ArrayList<File>();
    private static final PrintStream LOG = System.out;
    public static final IProgressMonitor LOGGER = new IProgressMonitor(){
        private String message = "";

        public void beginTask(String name, int totalWork) {
            this.filter(name);
        }

        public void done() {
        }

        public void internalWorked(double work) {
        }

        public boolean isCanceled() {
            return false;
        }

        public void setCanceled(boolean value) {
        }

        public void setTaskName(String name) {
            this.filter(name);
        }

        public void subTask(String name) {
            this.filter(name);
        }

        public void worked(int work) {
        }

        private void filter(String message) {
            if (message == null) {
                message = "";
            }
            if (!message.equals(this.message)) {
                AbstractTest.log(message);
            }
            this.message = message;
        }
    };
    @Rule
    public final TestWatcher failurePrinter = new FailurePrinter();
    @Rule
    public final TestName testName = new TestName();
    private File userHome;

    @Before
    public void setUp() throws Exception {
        AbstractTest.log("=========================================================================================================================\n" + this.testName.getMethodName() + "\n=========================================================================================================================");
    }

    @After
    public void tearDown() throws Exception {
        AbstractTest.log();
        for (File file : TEMP_FOLDERS) {
            IOUtil.deleteBestEffort((File)file);
        }
        TEMP_FOLDERS.clear();
        LOGGER.setTaskName(null);
    }

    public File getUserHome() {
        if (this.userHome == null) {
            this.userHome = AbstractTest.createTempFolder();
            System.setProperty("user.home", this.userHome.getAbsolutePath());
        }
        return this.userHome;
    }

    public File getTestFolder(OomphPlugin plugin, String name) {
        try {
            File folder = new File(this.getUserHome(), name);
            if (plugin != null) {
                OomphPlugin.BundleFile rootFile = plugin.getRootFile();
                OomphPlugin.BundleFile testRoot = rootFile.getChild("tests");
                OomphPlugin.BundleFile child = testRoot.getChild(name);
                child.export(folder);
                AbstractTest.log("Copied plugin:/" + plugin.getSymbolicName() + "/" + String.valueOf(child) + " to " + String.valueOf(folder));
            } else {
                IOUtil.mkdirs((File)folder);
                AbstractTest.log("Created folder " + String.valueOf(folder));
            }
            return folder;
        }
        catch (RuntimeException ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public static File createTempFolder() {
        File result = IOUtil.createTempFolder((String)"test-", (boolean)false);
        TEMP_FOLDERS.add(result);
        return result;
    }

    public static void log() {
        LOG.println();
    }

    public static void log(Object object) {
        if (object instanceof Throwable) {
            Throwable ex = (Throwable)object;
            AbstractTest.printStackTrace(ex);
        } else {
            LOG.println(object);
        }
    }

    public static void printStackTrace(Throwable ex) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ex.printStackTrace(new PrintStream(baos));
        List lines = IOUtil.readLines((InputStream)new ByteArrayInputStream(baos.toByteArray()), (String)"UTF-8");
        Iterator it = lines.iterator();
        while (it.hasNext()) {
            String line = ((String)it.next()).trim();
            int i = 0;
            while (i < FILTERS.length) {
                String filter = FILTERS[i];
                if (line.startsWith("at " + filter)) {
                    it.remove();
                }
                ++i;
            }
        }
        System.err.println(StringUtil.implode((List)lines, (char)'\n'));
    }

    public static Matcher<Object> isNull() {
        return IsNull.nullValue();
    }

    private static final class FailurePrinter
    extends TestWatcher {
        private FailurePrinter() {
        }

        protected void failed(Throwable ex, Description description) {
            AbstractTest.printStackTrace(ex);
        }
    }
}

