/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.gitbash.revision;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.internal.history.HistoryPageInput;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.oomph.gitbash.AbstractAction;
import org.eclipse.oomph.util.ObjectUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.ui.history.IHistoryView;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractRevisionAction
extends AbstractAction<RevObject> {
    public AbstractRevisionAction() {
        super(RevObject.class);
    }

    @Override
    protected void run(Shell shell, RevObject revision) throws Exception {
        Repository repository = this.getRepository();
        if (repository != null) {
            File workTree = repository.getWorkTree();
            this.run(shell, repository, workTree, revision);
        }
    }

    protected abstract void run(Shell var1, Repository var2, File var3, RevObject var4) throws Exception;

    protected Repository getRepository() {
        RepositoryMapping mapping;
        IResource resource;
        RepositoryMapping mapping2;
        Object input = this.getInput();
        if (input == null) {
            return null;
        }
        if (input instanceof HistoryPageInput) {
            return ((HistoryPageInput)input).getRepository();
        }
        if (input instanceof RepositoryTreeNode) {
            return ((RepositoryTreeNode)input).getRepository();
        }
        if (input instanceof IResource && (mapping2 = RepositoryMapping.getMapping((IResource)((IResource)input))) != null) {
            return mapping2.getRepository();
        }
        if (input instanceof IAdaptable && (resource = (IResource)ObjectUtil.adapt((Object)input, IResource.class)) != null && (mapping = RepositoryMapping.getMapping((IResource)resource)) != null) {
            return mapping.getRepository();
        }
        Repository repo = (Repository)Adapters.adapt((Object)input, Repository.class);
        if (repo != null) {
            return repo;
        }
        return null;
    }

    private Object getInput() {
        IWorkbenchPart part = this.getTargetPart();
        if (part instanceof IHistoryView) {
            return ((IHistoryView)part).getHistoryPage().getInput();
        }
        return null;
    }
}

