/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.installer;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Writer;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.ThreadPool;

public final class OwnershipMapper {
    private static final String FILE_SEPARATOR = System.getProperty("file.separator");
    private static final boolean DEBUG = FILE_SEPARATOR.equals("\\");
    private static final PosixFileAttributes DEBUG_ATTRIBUTES = DEBUG ? new DebugFileAttributes() : null;
    private static final FileFilter FOLDER_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            Path path = pathname.toPath();
            return !Files.isSymbolicLink(path) && Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS) && Files.isReadable(path);
        }
    };
    private static final String PROJECTS_NAME = "projects.txt";
    private static final boolean REFRESH_PROJECTS = Boolean.getBoolean("refresh.projects");
    private static final String EXEMPTION_RULES = DEBUG ? OwnershipMapper.getDebugExemptions() : System.getProperty("exemption.rules");
    private static final String ROOT = "ROOT";
    private static final String UNKNOWN = "UNKNOWN";
    private static final String IGNORE = "-";
    private static Path rootFolder;
    private static Map<String, String> projects;
    private static Map<Path, ExemptionRule> exemptionRules;
    private static Map<Path, String> mappings;
    private static Writer stats;

    static {
        exemptionRules = new LinkedHashMap<Path, ExemptionRule>();
        mappings = Collections.synchronizedMap(new HashMap());
    }

    public static void main(String[] args) throws Exception {
        rootFolder = Paths.get(args[0], new String[0]);
        mappings.put(rootFolder, ROOT);
        System.out.println("Mapping " + rootFolder);
        System.out.println();
        OwnershipMapper.initProjects();
        OwnershipMapper.initExemptionRules();
        Object[] topLevelFolders = rootFolder.toFile().listFiles(FOLDER_FILTER);
        if (topLevelFolders != null) {
            Arrays.sort(topLevelFolders);
            stats = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream("folders.txt"), "UTF-8"));
            long start = System.currentTimeMillis();
            ThreadPool threadPool = new ThreadPool();
            Object[] objectArray = topLevelFolders;
            int n = topLevelFolders.length;
            int n2 = 0;
            while (n2 < n) {
                Object topLevelFolder = objectArray[n2];
                threadPool.submit(new Runnable((File)topLevelFolder){
                    private final /* synthetic */ File val$topLevelFolder;
                    {
                        this.val$topLevelFolder = file;
                    }

                    @Override
                    public void run() {
                        try {
                            OwnershipMapper.processFolder(this.val$topLevelFolder.toPath());
                        }
                        catch (Exception ex) {
                            OwnershipMapper.printStackTrace(ex);
                        }
                    }
                });
                ++n2;
            }
            threadPool.awaitFinished();
            OwnershipMapper.writeStats(rootFolder.relativize(rootFolder), start, IGNORE, IGNORE, ROOT);
            stats.close();
            OwnershipMapper.writeResults();
            System.out.println();
        }
    }

    private static void processFolder(Path folder) throws Exception {
        block14: {
            Path path = rootFolder.relativize(folder);
            long start = System.currentTimeMillis();
            String user = IGNORE;
            String group = IGNORE;
            String project = UNKNOWN;
            try {
                File[] childFolders;
                ExemptionRule exemptionRule = exemptionRules.get(path);
                if (exemptionRule != null) {
                    project = exemptionRule.getProject();
                    if (project.equals(IGNORE)) {
                        return;
                    }
                    mappings.put(folder, project);
                    System.out.println(path + "\t" + project);
                    if (exemptionRule.isRecursive()) {
                        return;
                    }
                } else {
                    PosixFileAttributes attributes = OwnershipMapper.getAttributes(folder);
                    user = attributes.owner().getName();
                    group = attributes.group().getName();
                    project = OwnershipMapper.mapFolder(folder, user, group);
                    Path parent = folder.getParent();
                    Path stop = rootFolder.getParent();
                    while (parent != null && !parent.equals(stop)) {
                        String parentProject = mappings.get(parent);
                        if (parentProject != null) {
                            boolean unknown = UNKNOWN.equals(project);
                            if (parentProject.equals(project) || !ROOT.equals(parentProject) && unknown) break;
                            mappings.put(folder, project);
                            System.out.println(path + "\t" + project + (unknown ? "\t" + user + "\t" + group : ""));
                            break;
                        }
                        parent = parent.getParent();
                    }
                }
                if ((childFolders = folder.toFile().listFiles(FOLDER_FILTER)) == null) break block14;
                File[] fileArray = childFolders;
                int n = childFolders.length;
                int n2 = 0;
                while (n2 < n) {
                    File childFolder = fileArray[n2];
                    try {
                        OwnershipMapper.processFolder(childFolder.toPath());
                    }
                    catch (Exception ex) {
                        OwnershipMapper.printStackTrace(ex);
                    }
                    ++n2;
                }
            }
            finally {
                OwnershipMapper.writeStats(path, start, user, group, project);
            }
        }
    }

    private static String mapFolder(Path folder, String user, String group) {
        String suffix;
        List<String> ids;
        if (projects.containsKey(group)) {
            return group;
        }
        if (user.startsWith("genie.") && (ids = OwnershipMapper.getProjects(suffix = "." + user.substring("genie.".length()))).size() == 1) {
            return ids.get(0);
        }
        return UNKNOWN;
    }

    private static List<String> getProjects(String suffix) {
        ArrayList<String> result = new ArrayList<String>();
        for (String project : projects.keySet()) {
            if (!project.endsWith(suffix)) continue;
            result.add(project);
        }
        return result;
    }

    private static PosixFileAttributes getAttributes(Path folder) throws IOException {
        if (DEBUG_ATTRIBUTES != null) {
            return DEBUG_ATTRIBUTES;
        }
        return Files.getFileAttributeView(folder, PosixFileAttributeView.class, new LinkOption[0]).readAttributes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeStats(Path path, long start, String user, String group, String project) throws IOException {
        Writer writer = stats;
        synchronized (writer) {
            stats.write(path.toString());
            stats.write(FILE_SEPARATOR);
            stats.write("\t");
            stats.write(user);
            stats.write("\t");
            stats.write(group);
            stats.write("\t");
            stats.write(project);
            stats.write("\t");
            stats.write(Long.toString(System.currentTimeMillis() - start));
            stats.write("\n");
        }
    }

    private static void writeResults() throws IOException {
        BufferedWriter writer = new BufferedWriter(new FileWriter("mappings.txt"));
        Object[] folders = mappings.keySet().toArray(new Path[mappings.size()]);
        Arrays.sort(folders);
        ArrayList<Path> exemptions = new ArrayList<Path>();
        HashSet<String> unmappedProjects = new HashSet<String>(projects.keySet());
        Path lastFolder = null;
        Object[] objectArray = folders;
        int n = folders.length;
        int n2 = 0;
        while (n2 < n) {
            Object folder = objectArray[n2];
            String project = mappings.get(folder);
            Path relativeFolder = rootFolder.relativize((Path)folder);
            if (!ROOT.equals(project) && !UNKNOWN.equals(project)) {
                ExemptionRule existingRule;
                writer.write(relativeFolder.toString());
                writer.write(FILE_SEPARATOR);
                writer.write("\t");
                writer.write(project);
                writer.write("\n");
                if (!(lastFolder == null || relativeFolder.startsWith(lastFolder) || (existingRule = exemptionRules.get(lastFolder)) != null && existingRule.isRecursive())) {
                    exemptions.add(lastFolder);
                }
                lastFolder = relativeFolder;
                unmappedProjects.remove(project);
            }
            ++n2;
        }
        if (lastFolder != null) {
            exemptions.add(lastFolder);
        }
        ((Writer)writer).close();
        writer = new BufferedWriter(new FileWriter("exemptions.txt"));
        for (Path exemption : exemptions) {
            writer.write(exemption.toString());
            writer.write(FILE_SEPARATOR);
            writer.write(" ");
            writer.write(mappings.get(rootFolder.resolve(exemption)));
            writer.write("\n");
        }
        ((Writer)writer).close();
        if (!unmappedProjects.isEmpty()) {
            System.out.println();
            System.out.println("Unmapped Projects:");
            Object[] array = unmappedProjects.toArray(new String[unmappedProjects.size()]);
            Arrays.sort(array);
            Object[] objectArray2 = array;
            int n3 = array.length;
            n = 0;
            while (n < n3) {
                Object unmappedProject = objectArray2[n];
                System.out.println((String)unmappedProject);
                ++n;
            }
        }
    }

    private static void printStackTrace(Exception exception) {
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            PrintStream out = new PrintStream(bytes);
            exception.printStackTrace(out);
            System.err.write(bytes.toByteArray());
        }
        catch (Exception exception2) {
            // empty catch block
        }
    }

    private static void initProjects() throws Exception {
        File projectsFile = new File(PROJECTS_NAME);
        if (!projectsFile.exists() || REFRESH_PROJECTS) {
            projects = PMI.getProjects();
            ArrayList<String> ids = new ArrayList<String>(projects.keySet());
            Collections.sort(ids);
            BufferedWriter writer = new BufferedWriter(new FileWriter(projectsFile));
            try {
                for (String id : ids) {
                    writer.write(id);
                    writer.write("\t");
                    String name = projects.get(id);
                    if (name != null) {
                        writer.write(name);
                    }
                    writer.write("\n");
                }
            }
            finally {
                IOUtil.close((Closeable)writer);
            }
            System.out.println();
        } else {
            projects = new HashMap<String, String>();
            List lines = IOUtil.readLines((File)projectsFile, (String)"UTF-8");
            for (String line : lines) {
                int tab = line.indexOf(9);
                String id = line.substring(0, tab);
                String name = line.substring(tab + 1);
                projects.put(id, name);
            }
        }
    }

    private static void initExemptionRules() {
        if (EXEMPTION_RULES != null) {
            String[] stringArray = EXEMPTION_RULES.split("\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (!(line = line.trim().replace('\t', ' ')).isEmpty() && !line.startsWith("#")) {
                    boolean recursive;
                    Path folder;
                    if (line.equals(IGNORE)) break;
                    int sep = line.lastIndexOf(32);
                    String path = line.substring(0, sep);
                    String project = line.substring(sep + 1);
                    if (path.endsWith(FILE_SEPARATOR)) {
                        folder = Paths.get(path.substring(0, path.length() - 1), new String[0]);
                        recursive = true;
                        mappings.put(rootFolder.resolve(folder), project);
                    } else {
                        folder = Paths.get(path, new String[0]);
                        recursive = IGNORE.equals(project);
                    }
                    ExemptionRule exemptionRule = new ExemptionRule(project, recursive);
                    exemptionRules.put(folder, exemptionRule);
                    System.out.println(folder + " --> " + exemptionRule);
                }
                ++n2;
            }
            System.out.println();
        }
    }

    private static String getDebugExemptions() {
        return "   bin -\n   cdo-master\\ CDO\n   oomph OOMPH";
    }

    private static final class DebugFileAttributes
    implements PosixFileAttributes {
        private static final Random RANDOM = new Random();

        private DebugFileAttributes() {
        }

        @Override
        public UserPrincipal owner() {
            return new UserPrincipal(){

                @Override
                public String getName() {
                    return "foo.bar";
                }
            };
        }

        @Override
        public GroupPrincipal group() {
            return new GroupPrincipal(){

                @Override
                public String getName() {
                    int i = RANDOM.nextInt(4);
                    if (i == 3) {
                        return "foo.bar";
                    }
                    return projects.keySet().toArray(new String[projects.size()])[i % 3];
                }
            };
        }

        @Override
        public long size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public FileTime lastModifiedTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public FileTime lastAccessTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isSymbolicLink() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isRegularFile() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isOther() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isDirectory() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object fileKey() {
            throw new UnsupportedOperationException();
        }

        @Override
        public FileTime creationTime() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<PosixFilePermission> permissions() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class ExemptionRule {
        private final String project;
        private final boolean recursive;

        public ExemptionRule(String project, boolean recursive) {
            this.project = project;
            this.recursive = recursive;
        }

        public String getProject() {
            return this.project;
        }

        public boolean isRecursive() {
            return this.recursive;
        }

        public String toString() {
            if (OwnershipMapper.IGNORE.equals(this.project)) {
                return "ExemptionRule [IGNORE]";
            }
            return "ExemptionRule [project=" + this.project + ", recursive=" + this.recursive + "]";
        }
    }

    private static final class PMI {
        private static final String URL = "https://projects.eclipse.org/list-of-projects";
        private static final Pattern ID_PATTERN = Pattern.compile("<div[^>]+about=\"/projects/([^\"]+)\"[^>]+>");
        private static final String NEXT = "<li class=\"next\">";

        private PMI() {
        }

        public static Map<String, String> getProjects() throws Exception {
            HashMap<String, String> projects = new HashMap<String, String>();
            int page = 0;
            while (true) {
                String url = "https://projects.eclipse.org/list-of-projects?page=" + page;
                System.out.println("Processing " + url);
                InputStream stream = new URL(url).openStream();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try {
                    IOUtil.copy((InputStream)stream, (OutputStream)baos);
                }
                finally {
                    IOUtil.close((Closeable)stream);
                }
                String content = new String(baos.toByteArray(), "UTF-8");
                if (PMI.processPage(content, projects)) break;
                ++page;
            }
            return projects;
        }

        private static boolean processPage(String content, Map<String, String> projects) {
            Matcher matcher = ID_PATTERN.matcher(content);
            int start = 0;
            while (matcher.find(start)) {
                String project = matcher.group(1).trim();
                String name = "";
                Pattern namePattern = Pattern.compile("<a href=\"/projects/" + project.replace(".", "\\.") + "\">([^<]+)</a>");
                Matcher nameMatcher = namePattern.matcher(content);
                if (nameMatcher.find()) {
                    name = nameMatcher.group(1).trim().replace("\u2122", "").replace("\u00ae", "");
                }
                projects.put(project, name);
                start = matcher.end();
            }
            return !content.contains(NEXT);
        }
    }
}

