/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edit.ui.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.IViewerNotification;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.edit.ui.provider.NotifyChangedToViewerRefresh;
import org.eclipse.emf.edit.ui.provider.PropertySource;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

public class AdapterFactoryContentProvider
implements ITreeContentProvider,
IPropertySourceProvider,
INotifyChangedListener {
    protected AdapterFactory adapterFactory;
    protected Viewer viewer;
    protected ViewerRefresh viewerRefresh;
    private static final Class<?> IStructuredItemContentProviderClass = IStructuredItemContentProvider.class;
    private static final Class<?> ITreeItemContentProviderClass = ITreeItemContentProvider.class;
    private static final Class<?> IItemPropertySourceClass = IItemPropertySource.class;

    public AdapterFactoryContentProvider(AdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
        if (adapterFactory instanceof IChangeNotifier) {
            ((IChangeNotifier)adapterFactory).addListener((INotifyChangedListener)this);
        }
    }

    public void setAdapterFactory(AdapterFactory adapterFactory) {
        if (this.adapterFactory instanceof IChangeNotifier) {
            ((IChangeNotifier)this.adapterFactory).removeListener((INotifyChangedListener)this);
        }
        if (adapterFactory instanceof IChangeNotifier) {
            ((IChangeNotifier)adapterFactory).addListener((INotifyChangedListener)this);
        }
        this.adapterFactory = adapterFactory;
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
    }

    public Object[] getElements(Object object) {
        IStructuredItemContentProvider structuredItemContentProvider = (IStructuredItemContentProvider)this.adapterFactory.adapt(object, IStructuredItemContentProviderClass);
        return (structuredItemContentProvider != null ? structuredItemContentProvider.getElements(object) : Collections.EMPTY_LIST).toArray();
    }

    public Object[] getChildren(Object object) {
        ITreeItemContentProvider treeItemContentProvider = (ITreeItemContentProvider)this.adapterFactory.adapt(object, ITreeItemContentProviderClass);
        return (treeItemContentProvider != null ? treeItemContentProvider.getChildren(object) : Collections.EMPTY_LIST).toArray();
    }

    public boolean hasChildren(Object object) {
        ITreeItemContentProvider treeItemContentProvider = (ITreeItemContentProvider)this.adapterFactory.adapt(object, ITreeItemContentProviderClass);
        return treeItemContentProvider != null && treeItemContentProvider.hasChildren(object);
    }

    public Object getParent(Object object) {
        ITreeItemContentProvider treeItemContentProvider = (ITreeItemContentProvider)this.adapterFactory.adapt(object, ITreeItemContentProviderClass);
        return treeItemContentProvider != null ? treeItemContentProvider.getParent(object) : null;
    }

    public void dispose() {
        if (this.adapterFactory instanceof IChangeNotifier) {
            ((IChangeNotifier)this.adapterFactory).removeListener((INotifyChangedListener)this);
        }
        this.viewer = null;
    }

    public IPropertySource getPropertySource(Object object) {
        if (object instanceof IPropertySource) {
            return (IPropertySource)object;
        }
        IItemPropertySource itemPropertySource = (IItemPropertySource)(object instanceof EObject && ((EObject)object).eClass() == null ? null : this.adapterFactory.adapt(object, IItemPropertySourceClass));
        return itemPropertySource != null ? this.createPropertySource(object, itemPropertySource) : null;
    }

    protected IPropertySource createPropertySource(Object object, IItemPropertySource itemPropertySource) {
        return new PropertySource(object, itemPropertySource);
    }

    public void notifyChanged(Notification notification) {
        if (this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed()) {
            if (notification instanceof IViewerNotification) {
                if (this.viewerRefresh == null) {
                    this.viewerRefresh = new ViewerRefresh(this.viewer, this.getViewerRefreshTheshold());
                }
                if (this.viewerRefresh.addNotification((IViewerNotification)notification)) {
                    final Display display = this.viewer.getControl().getDisplay();
                    final int viewerRefreshDelay = this.getViewerRefreshDelay();
                    if (viewerRefreshDelay > 0 && display.getThread() != Thread.currentThread()) {
                        display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                display.timerExec(viewerRefreshDelay, (Runnable)AdapterFactoryContentProvider.this.viewerRefresh);
                            }
                        });
                    } else {
                        display.asyncExec((Runnable)this.viewerRefresh);
                    }
                }
            } else {
                NotifyChangedToViewerRefresh.handleNotifyChanged(this.viewer, notification.getNotifier(), notification.getEventType(), notification.getFeature(), notification.getOldValue(), notification.getNewValue(), notification.getPosition());
            }
        }
    }

    protected int getViewerRefreshTheshold() {
        return 30;
    }

    protected int getViewerRefreshDelay() {
        return 200;
    }

    public static class ViewerRefresh
    implements Runnable {
        private Viewer viewer;
        private List<IViewerNotification> notifications;
        private boolean compatibility;
        private int count;
        private int threshold;

        public ViewerRefresh(Viewer viewer) {
            this(viewer, Integer.MAX_VALUE);
        }

        public ViewerRefresh(Viewer viewer, int threshold) {
            this.viewer = viewer;
            this.threshold = threshold;
        }

        @Deprecated
        public ViewerRefresh(Viewer viewer, IViewerNotification notification) {
            this.viewer = viewer;
            this.addNotification(notification);
            this.compatibility = true;
        }

        public synchronized boolean addNotification(IViewerNotification notification) {
            if (this.notifications == null) {
                this.notifications = new ArrayList<IViewerNotification>();
                this.count = 0;
            }
            if (this.notifications.isEmpty()) {
                ++this.count;
                this.notifications.add(notification);
                return true;
            }
            if (this.viewer instanceof StructuredViewer) {
                if (this.count > this.threshold) {
                    if (this.notifications.size() != 1) {
                        this.notifications.clear();
                        this.notifications.add((IViewerNotification)new ViewerNotification((Notification)notification, null, true, true));
                    }
                } else {
                    Iterator<IViewerNotification> i = this.notifications.iterator();
                    while (i.hasNext() && notification != null) {
                        IViewerNotification old = i.next();
                        IViewerNotification merged = this.merge(old, notification);
                        if (merged == old) {
                            notification = null;
                            continue;
                        }
                        if (merged == null) continue;
                        notification = merged;
                        --this.count;
                        i.remove();
                    }
                    if (notification != null) {
                        this.notifications.add(notification);
                        ++this.count;
                    }
                }
            }
            return false;
        }

        protected IViewerNotification merge(IViewerNotification n1, IViewerNotification n2) {
            if (n1.getElement() == null && n1.isLabelUpdate()) {
                return n1;
            }
            if (n2.getElement() == null && n2.isLabelUpdate()) {
                return n2;
            }
            if (n1.getElement() == null) {
                if (n2.isLabelUpdate()) {
                    n1 = new ViewerNotification((Notification)n1);
                }
                return n1;
            }
            if (n2.getElement() == null) {
                if (n1.isLabelUpdate()) {
                    n2 = new ViewerNotification((Notification)n2);
                }
                return n2;
            }
            if (n1.getElement() == n2.getElement()) {
                if (n1.isContentRefresh() && n1.isLabelUpdate()) {
                    return n1;
                }
                if (n2.isContentRefresh() && n2.isLabelUpdate()) {
                    return n2;
                }
                if (n1.isContentRefresh()) {
                    if (n2.isLabelUpdate()) {
                        n1 = new ViewerNotification((Notification)n1, n1.getElement(), true, true);
                    }
                    return n1;
                }
                if (n2.isContentRefresh()) {
                    if (n1.isLabelUpdate()) {
                        n2 = new ViewerNotification((Notification)n2, n2.getElement(), true, true);
                    }
                    return n2;
                }
                if (n1.isLabelUpdate()) {
                    return n1;
                }
                return n2;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed()) {
                List<IViewerNotification> current;
                ViewerRefresh viewerRefresh = this;
                synchronized (viewerRefresh) {
                    current = this.notifications;
                    this.notifications = null;
                }
                if (current != null) {
                    for (IViewerNotification viewerNotification : current) {
                        this.refresh(viewerNotification);
                    }
                }
            }
        }

        protected void refresh(IViewerNotification notification) {
            if (this.compatibility && notification.getEventType() == 9) {
                return;
            }
            Object element = notification.getElement();
            if (this.viewer instanceof StructuredViewer) {
                StructuredViewer structuredViewer = (StructuredViewer)this.viewer;
                ISelection selection = structuredViewer.getSelection();
                boolean isStaleSelection = AdapterFactoryEditingDomain.isStale((Object)selection);
                if (isStaleSelection) {
                    this.viewer.setSelection((ISelection)StructuredSelection.EMPTY);
                }
                AbstractTreeViewer treeViewer = structuredViewer instanceof AbstractTreeViewer ? (AbstractTreeViewer)structuredViewer : null;
                List expandedElements = treeViewer == null ? Collections.emptyList() : Arrays.asList(treeViewer.getExpandedElements());
                boolean isStaleExpandedElements = AdapterFactoryEditingDomain.isStale(expandedElements);
                if (element != null) {
                    if (notification.isContentRefresh()) {
                        structuredViewer.refresh(element, notification.isLabelUpdate());
                    } else if (notification.isLabelUpdate()) {
                        structuredViewer.update(element, null);
                    }
                } else {
                    structuredViewer.refresh(notification.isLabelUpdate());
                }
                if (isStaleSelection || isStaleExpandedElements) {
                    Object object = structuredViewer.getInput();
                    EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((Object)object);
                    if (editingDomain == null) {
                        Object[] objectArray = ((IStructuredContentProvider)structuredViewer.getContentProvider()).getElements(object);
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object child = objectArray[n2];
                            editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((Object)child);
                            if (editingDomain != null) break;
                            ++n2;
                        }
                    }
                    if (editingDomain instanceof AdapterFactoryEditingDomain) {
                        AdapterFactoryEditingDomain adapterFactoryEditingDomain = (AdapterFactoryEditingDomain)editingDomain;
                        if (treeViewer != null && isStaleExpandedElements) {
                            treeViewer.setExpandedElements(adapterFactoryEditingDomain.resolve(expandedElements).toArray());
                        }
                        if (isStaleSelection) {
                            structuredViewer.setSelection((ISelection)new StructuredSelection(adapterFactoryEditingDomain.resolve((Collection)((IStructuredSelection)selection).toList())), true);
                        }
                    }
                }
            } else {
                this.viewer.refresh();
            }
        }
    }
}

