/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.internal.generator;

import java.util.function.Consumer;
import org.eclipse.jetty.http3.frames.Frame;
import org.eclipse.jetty.http3.frames.FrameType;
import org.eclipse.jetty.http3.internal.generator.DataGenerator;
import org.eclipse.jetty.http3.internal.generator.FrameGenerator;
import org.eclipse.jetty.http3.internal.generator.HeadersGenerator;
import org.eclipse.jetty.http3.internal.generator.PushPromiseGenerator;
import org.eclipse.jetty.http3.qpack.QpackEncoder;
import org.eclipse.jetty.io.ByteBufferPool;

public class MessageGenerator {
    private final FrameGenerator[] generators = new FrameGenerator[FrameType.maxType() + 1];

    public MessageGenerator(QpackEncoder encoder, int maxHeadersLength, boolean useDirectByteBuffers) {
        this.generators[FrameType.DATA.type()] = new DataGenerator(useDirectByteBuffers);
        this.generators[FrameType.HEADERS.type()] = new HeadersGenerator(encoder, maxHeadersLength, useDirectByteBuffers);
        this.generators[FrameType.PUSH_PROMISE.type()] = new PushPromiseGenerator();
    }

    public int generate(ByteBufferPool.Lease lease, long streamId, Frame frame, Consumer<Throwable> fail) {
        return this.generators[frame.getFrameType().type()].generate(lease, streamId, frame, fail);
    }
}

