/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.server;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.CyclicTimeouts;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.quic.common.QuicConnection;
import org.eclipse.jetty.quic.common.QuicSession;
import org.eclipse.jetty.quic.quiche.QuicheConfig;
import org.eclipse.jetty.quic.quiche.QuicheConnection;
import org.eclipse.jetty.quic.server.QuicServerConnector;
import org.eclipse.jetty.quic.server.ServerQuicSession;
import org.eclipse.jetty.quic.server.internal.SimpleTokenMinter;
import org.eclipse.jetty.quic.server.internal.SimpleTokenValidator;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.thread.Scheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerQuicConnection
extends QuicConnection {
    private static final Logger LOG = LoggerFactory.getLogger(ServerQuicConnection.class);
    private final QuicServerConnector connector;
    private final SessionTimeouts sessionTimeouts;

    protected ServerQuicConnection(QuicServerConnector connector, EndPoint endPoint) {
        super(connector.getExecutor(), connector.getScheduler(), connector.getByteBufferPool(), endPoint);
        this.connector = connector;
        this.sessionTimeouts = new SessionTimeouts(connector.getScheduler());
    }

    public void onOpen() {
        super.onOpen();
        this.fillInterested();
    }

    protected QuicSession createSession(SocketAddress remoteAddress, ByteBuffer cipherBuffer) throws IOException {
        ByteBufferPool byteBufferPool = this.getByteBufferPool();
        QuicheConnection quicheConnection = QuicheConnection.tryAccept((QuicheConfig)this.connector.newQuicheConfig(), (QuicheConnection.TokenValidator)new SimpleTokenValidator((InetSocketAddress)remoteAddress), (ByteBuffer)cipherBuffer, (SocketAddress)remoteAddress);
        if (quicheConnection == null) {
            ByteBuffer negotiationBuffer = byteBufferPool.acquire(this.getOutputBufferSize(), true);
            int pos = BufferUtil.flipToFill((ByteBuffer)negotiationBuffer);
            if (!QuicheConnection.negotiate((QuicheConnection.TokenMinter)new SimpleTokenMinter((InetSocketAddress)remoteAddress), (ByteBuffer)cipherBuffer, (ByteBuffer)negotiationBuffer)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("QUIC connection negotiation failed, dropping packet");
                }
                byteBufferPool.release(negotiationBuffer);
                return null;
            }
            BufferUtil.flipToFlush((ByteBuffer)negotiationBuffer, (int)pos);
            this.write(Callback.from(() -> byteBufferPool.release(negotiationBuffer)), remoteAddress, new ByteBuffer[]{negotiationBuffer});
            if (LOG.isDebugEnabled()) {
                LOG.debug("QUIC connection negotiation packet sent");
            }
            return null;
        }
        ServerQuicSession session = new ServerQuicSession(this.getExecutor(), this.getScheduler(), byteBufferPool, quicheConnection, this, remoteAddress, (Connector)this.connector);
        session.flush();
        return session;
    }

    public void schedule(ServerQuicSession session) {
        this.sessionTimeouts.schedule(session);
    }

    public boolean onIdleExpired() {
        return false;
    }

    public void outwardClose(QuicSession session, Throwable failure) {
        super.outwardClose(session, failure);
    }

    private class SessionTimeouts
    extends CyclicTimeouts<ServerQuicSession> {
        private SessionTimeouts(Scheduler scheduler) {
            super(scheduler);
        }

        protected Iterator<ServerQuicSession> iterator() {
            return ServerQuicConnection.this.getQuicSessions().stream().map(ServerQuicSession.class::cast).iterator();
        }

        protected boolean onExpired(ServerQuicSession session) {
            session.onIdleTimeout();
            return false;
        }
    }
}

