/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.server.internal;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.UserIdentity;

public class UpgradeHttpServletRequest
implements HttpServletRequest {
    private static final String UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE = "Feature unsupported after Upgraded to WebSocket";
    private HttpServletRequest request;
    private final ServletContext context;
    private final DispatcherType dispatcher;
    private final String method;
    private final String protocol;
    private final String scheme;
    private final boolean secure;
    private final String requestURI;
    private final StringBuffer requestURL;
    private final String pathInfo;
    private final String pathTranslated;
    private final String servletPath;
    private final String query;
    private final String authType;
    private final Cookie[] cookies;
    private final String remoteUser;
    private final Principal principal;
    private final Authentication authentication;
    private final UserIdentity.Scope scope;
    private final Map<String, List<String>> headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, String[]> parameters = new TreeMap<String, String[]>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, Object> attributes = new HashMap<String, Object>(2);
    private final List<Locale> locales = new ArrayList<Locale>(2);
    private final HttpSession session;
    private final InetSocketAddress localAddress;
    private final String localName;
    private final InetSocketAddress remoteAddress;
    private final String remoteName;
    private final InetSocketAddress serverAddress;
    private boolean isAsyncStarted;
    private boolean isAsyncSupported;

    public UpgradeHttpServletRequest(HttpServletRequest httpRequest) {
        this.request = httpRequest;
        this.context = httpRequest.getServletContext();
        this.dispatcher = httpRequest.getDispatcherType();
        this.method = httpRequest.getMethod();
        this.protocol = httpRequest.getProtocol();
        this.scheme = httpRequest.getScheme();
        this.secure = httpRequest.isSecure();
        this.requestURI = httpRequest.getRequestURI();
        this.requestURL = httpRequest.getRequestURL();
        this.pathInfo = httpRequest.getPathInfo();
        this.pathTranslated = httpRequest.getPathTranslated();
        this.servletPath = httpRequest.getServletPath();
        this.query = httpRequest.getQueryString();
        this.authType = httpRequest.getAuthType();
        this.cookies = httpRequest.getCookies();
        this.session = httpRequest.getSession(false);
        this.remoteUser = httpRequest.getRemoteUser();
        this.principal = httpRequest.getUserPrincipal();
        Request baseRequest = Objects.requireNonNull(Request.getBaseRequest((ServletRequest)httpRequest));
        this.authentication = baseRequest.getAuthentication();
        this.scope = baseRequest.getUserIdentityScope();
        Enumeration headerNames = httpRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            this.headers.put(name, Collections.list(httpRequest.getHeaders(name)));
        }
        this.parameters.putAll(httpRequest.getParameterMap());
        Enumeration localeElements = httpRequest.getLocales();
        while (localeElements.hasMoreElements()) {
            this.locales.add((Locale)localeElements.nextElement());
        }
        this.localAddress = InetSocketAddress.createUnresolved(httpRequest.getLocalAddr(), httpRequest.getLocalPort());
        this.localName = httpRequest.getLocalName();
        this.remoteAddress = InetSocketAddress.createUnresolved(httpRequest.getRemoteAddr(), httpRequest.getRemotePort());
        this.remoteName = httpRequest.getRemoteHost();
        this.serverAddress = InetSocketAddress.createUnresolved(httpRequest.getServerName(), httpRequest.getServerPort());
    }

    public void upgrade() {
        Enumeration attributeNames = this.request.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String name = (String)attributeNames.nextElement();
            this.attributes.put(name, this.request.getAttribute(name));
        }
        this.isAsyncStarted = this.request.isAsyncStarted();
        this.isAsyncSupported = this.request.isAsyncSupported();
        this.request = null;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.request;
    }

    public String getAuthType() {
        return this.authType;
    }

    public Cookie[] getCookies() {
        return this.cookies;
    }

    public String getHeader(String name) {
        List<String> values = this.headers.get(name);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return values.get(0);
    }

    public Enumeration<String> getHeaders(String name) {
        List<String> values = this.headers.get(name);
        if (values == null) {
            return Collections.emptyEnumeration();
        }
        return Collections.enumeration(values);
    }

    public Map<String, List<String>> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.headers.keySet());
    }

    public long getDateHeader(String name) {
        if (this.request == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        return this.request.getDateHeader(name);
    }

    public int getIntHeader(String name) {
        if (this.request == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        return this.request.getIntHeader(name);
    }

    public String getMethod() {
        return this.method;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPathTranslated() {
        return this.pathTranslated;
    }

    public String getContextPath() {
        return this.context.getContextPath();
    }

    public String getQueryString() {
        return this.query;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public boolean isUserInRole(String role) {
        if (this.authentication instanceof Authentication.User) {
            return ((Authentication.User)this.authentication).isUserInRole(this.scope, role);
        }
        return false;
    }

    public Principal getUserPrincipal() {
        return this.principal;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public StringBuffer getRequestURL() {
        return this.requestURL;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public HttpSession getSession(boolean create) {
        if (create && this.session == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        return this.session;
    }

    public HttpSession getSession() {
        return this.session;
    }

    public String getRequestedSessionId() {
        if (this.request == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        return this.request.getRequestedSessionId();
    }

    public boolean isRequestedSessionIdValid() {
        if (this.request == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        return this.request.isRequestedSessionIdValid();
    }

    public boolean isRequestedSessionIdFromCookie() {
        if (this.request == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        return this.request.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        if (this.request == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        return this.request.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromUrl() {
        if (this.request == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        return this.request.isRequestedSessionIdFromUrl();
    }

    public Object getAttribute(String name) {
        if (this.request == null) {
            return this.attributes.get(name);
        }
        return this.request.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        if (this.request == null) {
            return Collections.enumeration(this.attributes.keySet());
        }
        return this.request.getAttributeNames();
    }

    public String getParameter(String name) {
        String[] values = this.parameters.get(name);
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public String[] getParameterValues(String name) {
        return this.parameters.get(name);
    }

    public Map<String, String[]> getParameterMap() {
        return this.parameters;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getServerName() {
        return this.serverAddress.getHostString();
    }

    public int getServerPort() {
        return this.serverAddress.getPort();
    }

    public String getRemoteAddr() {
        return this.remoteAddress.getHostString();
    }

    public int getRemotePort() {
        return this.remoteAddress.getPort();
    }

    public String getRemoteHost() {
        return this.remoteName;
    }

    public void setAttribute(String name, Object value) {
        if (this.request == null) {
            this.attributes.put(name, value);
        } else {
            this.request.setAttribute(name, value);
        }
    }

    public void removeAttribute(String name) {
        if (this.request == null) {
            this.attributes.remove(name);
        } else {
            this.request.removeAttribute(name);
        }
    }

    public Locale getLocale() {
        if (this.locales.isEmpty()) {
            return Locale.getDefault();
        }
        return this.locales.get(0);
    }

    public Enumeration<Locale> getLocales() {
        return Collections.enumeration(this.locales);
    }

    public boolean isSecure() {
        return this.secure;
    }

    public String getRealPath(String path) {
        return this.context.getRealPath(path);
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getLocalAddr() {
        return this.localAddress.getHostString();
    }

    public int getLocalPort() {
        return this.localAddress.getPort();
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public DispatcherType getDispatcherType() {
        return this.dispatcher;
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        if (this.request == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        return this.request.authenticate(response);
    }

    public String changeSessionId() {
        if (this.request == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        return this.request.changeSessionId();
    }

    public AsyncContext getAsyncContext() {
        if (this.request == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        return this.request.getAsyncContext();
    }

    public String getCharacterEncoding() {
        if (this.request == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        return this.request.getCharacterEncoding();
    }

    public int getContentLength() {
        if (this.request == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        return this.request.getContentLength();
    }

    public long getContentLengthLong() {
        if (this.request == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        return this.request.getContentLengthLong();
    }

    public String getContentType() {
        if (this.request == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        return this.request.getContentType();
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.request == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        return this.request.getInputStream();
    }

    public Part getPart(String name) throws IOException, ServletException {
        if (this.request == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        return this.request.getPart(name);
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        if (this.request == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        return this.request.getParts();
    }

    public BufferedReader getReader() throws IOException {
        if (this.request == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        return this.request.getReader();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (this.request == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        return this.request.getRequestDispatcher(path);
    }

    public boolean isAsyncStarted() {
        if (this.request == null) {
            return this.isAsyncStarted;
        }
        return this.request.isAsyncStarted();
    }

    public boolean isAsyncSupported() {
        if (this.request == null) {
            return this.isAsyncSupported;
        }
        return this.request.isAsyncSupported();
    }

    public void login(String username, String password) throws ServletException {
        if (this.request == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        this.request.login(username, password);
    }

    public void logout() throws ServletException {
        if (this.request == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        this.request.logout();
    }

    public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
        if (this.request == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        this.request.setCharacterEncoding(enc);
    }

    public AsyncContext startAsync() throws IllegalStateException {
        if (this.request == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        return this.request.startAsync();
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        if (this.request == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        return this.request.startAsync(servletRequest, servletResponse);
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> handlerClass) throws IOException, ServletException {
        if (this.request == null) {
            throw new UnsupportedOperationException(UNSUPPORTED_AFTER_WEBSOCKET_UPGRADE);
        }
        return (T)this.request.upgrade(handlerClass);
    }
}

