/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ant;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Property;
import org.eclipse.jetty.ant.AntWebAppContext;
import org.eclipse.jetty.ant.ServerProxyImpl;
import org.eclipse.jetty.ant.types.Connector;
import org.eclipse.jetty.ant.types.Connectors;
import org.eclipse.jetty.ant.types.ContextHandlers;
import org.eclipse.jetty.ant.types.LoginServices;
import org.eclipse.jetty.ant.types.SystemProperties;
import org.eclipse.jetty.ant.utils.TaskLog;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.webapp.WebAppContext;

public class JettyRunTask
extends Task {
    private int scanIntervalSeconds;
    private File tempDirectory;
    private List<AntWebAppContext> webapps = new ArrayList<AntWebAppContext>();
    private File jettyXml;
    private Connectors connectors = null;
    private RequestLog requestLog;
    private LoginServices loginServices;
    private SystemProperties systemProperties;
    private ContextHandlers contextHandlers;
    private int jettyPort = 8080;
    private int stopPort;
    private String stopKey;
    private boolean daemon;

    public JettyRunTask() {
        TaskLog.setTask(this);
    }

    public void addWebApp(AntWebAppContext webapp) {
        this.webapps.add(webapp);
    }

    public void addConnectors(Connectors connectors) {
        if (this.connectors != null) {
            throw new BuildException("Only one <connectors> tag is allowed!");
        }
        this.connectors = connectors;
    }

    public void addLoginServices(LoginServices services) {
        if (this.loginServices != null) {
            throw new BuildException("Only one <loginServices> tag is allowed!");
        }
        this.loginServices = services;
    }

    public void addSystemProperties(SystemProperties systemProperties) {
        if (this.systemProperties != null) {
            throw new BuildException("Only one <systemProperties> tag is allowed!");
        }
        this.systemProperties = systemProperties;
    }

    public void addContextHandlers(ContextHandlers handlers) {
        if (this.contextHandlers != null) {
            throw new BuildException("Only one <contextHandlers> tag is allowed!");
        }
        this.contextHandlers = handlers;
    }

    public File getTempDirectory() {
        return this.tempDirectory;
    }

    public void setTempDirectory(File tempDirectory) {
        this.tempDirectory = tempDirectory;
    }

    public File getJettyXml() {
        return this.jettyXml;
    }

    public void setJettyXml(File jettyXml) {
        this.jettyXml = jettyXml;
    }

    public void setRequestLog(String className) {
        try {
            this.requestLog = (RequestLog)Class.forName(className).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new BuildException("Unknown request logger class: " + className);
        }
        catch (Exception e) {
            throw new BuildException("Request logger instantiation exception: " + e);
        }
    }

    public String getRequestLog() {
        if (this.requestLog != null) {
            return this.requestLog.getClass().getName();
        }
        return "";
    }

    public void setJettyPort(int jettyPort) {
        this.jettyPort = jettyPort;
    }

    public void execute() throws BuildException {
        TaskLog.log("Configuring Jetty for project: " + this.getProject().getName());
        this.setSystemProperties();
        List<Connector> connectorsList = null;
        connectorsList = this.connectors != null ? this.connectors.getConnectors() : new Connectors(this.jettyPort, 30000).getDefaultConnectors();
        ArrayList<LoginService> loginServicesList = this.loginServices != null ? this.loginServices.getLoginServices() : new ArrayList();
        ServerProxyImpl server = new ServerProxyImpl();
        server.setConnectors(connectorsList);
        server.setLoginServices(loginServicesList);
        server.setRequestLog(this.requestLog);
        server.setJettyXml(this.jettyXml);
        server.setDaemon(this.daemon);
        server.setStopPort(this.stopPort);
        server.setStopKey(this.stopKey);
        server.setContextHandlers(this.contextHandlers);
        server.setTempDirectory(this.tempDirectory);
        server.setScanIntervalSecs(this.scanIntervalSeconds);
        try {
            for (WebAppContext webAppContext : this.webapps) {
                server.addWebApplication((AntWebAppContext)webAppContext);
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        server.start();
    }

    public int getStopPort() {
        return this.stopPort;
    }

    public void setStopPort(int stopPort) {
        this.stopPort = stopPort;
        TaskLog.log("stopPort=" + stopPort);
    }

    public String getStopKey() {
        return this.stopKey;
    }

    public void setStopKey(String stopKey) {
        this.stopKey = stopKey;
        TaskLog.log("stopKey=" + stopKey);
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
        TaskLog.log("Daemon=" + daemon);
    }

    public int getScanIntervalSeconds() {
        return this.scanIntervalSeconds;
    }

    public void setScanIntervalSeconds(int secs) {
        this.scanIntervalSeconds = secs;
        TaskLog.log("scanIntervalSecs=" + secs);
    }

    private void setSystemProperties() {
        if (this.systemProperties != null) {
            for (Property property : this.systemProperties.getSystemProperties()) {
                SystemProperties.setIfNotSetAlready(property);
            }
        }
    }
}

