/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.jaspi;

import java.security.Permission;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.security.auth.message.config.AuthConfigFactory;
import javax.security.auth.message.config.AuthConfigProvider;
import javax.security.auth.message.config.RegistrationListener;
import org.eclipse.jetty.util.security.SecurityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAuthConfigFactory
extends AuthConfigFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAuthConfigFactory.class);
    private final Map<String, DefaultRegistrationContext> _registrations = new ConcurrentHashMap<String, DefaultRegistrationContext>();

    public AuthConfigProvider getConfigProvider(String layer, String appContext, RegistrationListener listener) {
        DefaultRegistrationContext registrationContext = this._registrations.get(DefaultAuthConfigFactory.getKey(layer, appContext));
        if (registrationContext == null) {
            registrationContext = this._registrations.get(DefaultAuthConfigFactory.getKey(null, appContext));
        }
        if (registrationContext == null) {
            registrationContext = this._registrations.get(DefaultAuthConfigFactory.getKey(layer, null));
        }
        if (registrationContext == null) {
            registrationContext = this._registrations.get(DefaultAuthConfigFactory.getKey(null, null));
        }
        if (registrationContext == null) {
            return null;
        }
        if (listener != null) {
            registrationContext.addListener(listener);
        }
        return registrationContext.getProvider();
    }

    public String registerConfigProvider(String className, Map properties, String layer, String appContext, String description) {
        DefaultAuthConfigFactory.checkPermission();
        String key = DefaultAuthConfigFactory.getKey(layer, appContext);
        AuthConfigProvider configProvider = this.createConfigProvider(className, properties);
        DefaultRegistrationContext context = new DefaultRegistrationContext(configProvider, layer, appContext, description, true);
        DefaultRegistrationContext oldContext = this._registrations.put(key, context);
        if (oldContext != null) {
            oldContext.notifyListeners();
        }
        return key;
    }

    public String registerConfigProvider(AuthConfigProvider provider, String layer, String appContext, String description) {
        DefaultAuthConfigFactory.checkPermission();
        String key = DefaultAuthConfigFactory.getKey(layer, appContext);
        DefaultRegistrationContext context = new DefaultRegistrationContext(provider, layer, appContext, description, false);
        DefaultRegistrationContext oldContext = this._registrations.put(key, context);
        if (oldContext != null) {
            oldContext.notifyListeners();
        }
        return key;
    }

    public boolean removeRegistration(String registrationID) {
        DefaultAuthConfigFactory.checkPermission();
        DefaultRegistrationContext registrationContext = this._registrations.remove(registrationID);
        if (registrationContext == null) {
            return false;
        }
        registrationContext.notifyListeners();
        return true;
    }

    public String[] detachListener(RegistrationListener listener, String layer, String appContext) {
        DefaultAuthConfigFactory.checkPermission();
        ArrayList<String> registrationIds = new ArrayList<String>();
        for (DefaultRegistrationContext registration : this._registrations.values()) {
            if (layer != null && !layer.equals(registration.getMessageLayer()) || appContext != null && !appContext.equals(registration.getAppContext()) || !registration.removeListener(listener)) continue;
            registrationIds.add(DefaultAuthConfigFactory.getKey(registration.getMessageLayer(), registration.getAppContext()));
        }
        return registrationIds.toArray(new String[0]);
    }

    public String[] getRegistrationIDs(AuthConfigProvider provider) {
        ArrayList<String> registrationIds = new ArrayList<String>();
        for (DefaultRegistrationContext registration : this._registrations.values()) {
            if (provider != registration.getProvider()) continue;
            registrationIds.add(DefaultAuthConfigFactory.getKey(registration.getMessageLayer(), registration.getAppContext()));
        }
        return registrationIds.toArray(new String[0]);
    }

    public AuthConfigFactory.RegistrationContext getRegistrationContext(String registrationID) {
        return this._registrations.get(registrationID);
    }

    public void refresh() {
        DefaultAuthConfigFactory.checkPermission();
    }

    private static void checkPermission() {
        SecurityUtils.checkPermission((Permission)providerRegistrationSecurityPermission);
    }

    private static String getKey(String layer, String appContext) {
        return layer + "/" + appContext;
    }

    private AuthConfigProvider createConfigProvider(String className, Map properties) {
        try {
            return (AuthConfigProvider)Class.forName(className).getConstructor(Map.class, AuthConfigFactory.class).newInstance(properties, null);
        }
        catch (ReflectiveOperationException e) {
            throw new SecurityException(e);
        }
    }

    private static class DefaultRegistrationContext
    implements AuthConfigFactory.RegistrationContext {
        private final String _layer;
        private final String _appContext;
        private final boolean _persistent;
        private final AuthConfigProvider _provider;
        private final String _description;
        private final List<RegistrationListener> _listeners = new CopyOnWriteArrayList<RegistrationListener>();

        public DefaultRegistrationContext(AuthConfigProvider provider, String layer, String appContext, String description, boolean persistent) {
            this._provider = provider;
            this._layer = layer;
            this._appContext = appContext;
            this._description = description;
            this._persistent = persistent;
        }

        public AuthConfigProvider getProvider() {
            return this._provider;
        }

        public String getMessageLayer() {
            return this._layer;
        }

        public String getAppContext() {
            return this._appContext;
        }

        public String getDescription() {
            return this._description;
        }

        public boolean isPersistent() {
            return false;
        }

        public void addListener(RegistrationListener listener) {
            this._listeners.add(listener);
        }

        public void notifyListeners() {
            for (RegistrationListener listener : this._listeners) {
                try {
                    listener.notify(this._layer, this._appContext);
                }
                catch (Throwable t) {
                    LOG.warn("Error from RegistrationListener", t);
                }
            }
        }

        public boolean removeListener(RegistrationListener listener) {
            return this._listeners.remove(listener);
        }
    }
}

