/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.quiche;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.security.Key;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Base64;
import java.util.Enumeration;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PemExporter {
    private static final Logger LOG = LoggerFactory.getLogger(PemExporter.class);
    private static final byte[] BEGIN_KEY = "-----BEGIN PRIVATE KEY-----".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] END_KEY = "-----END PRIVATE KEY-----".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] BEGIN_CERT = "-----BEGIN CERTIFICATE-----".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] END_CERT = "-----END CERTIFICATE-----".getBytes(StandardCharsets.US_ASCII);
    private static final byte[] LINE_SEPARATOR = System.getProperty("line.separator").getBytes(StandardCharsets.US_ASCII);
    private static final Base64.Encoder ENCODER = Base64.getMimeEncoder(64, LINE_SEPARATOR);

    private PemExporter() {
    }

    public static Path exportTrustStore(KeyStore keyStore, Path targetFolder) throws Exception {
        if (!Files.isDirectory(targetFolder, new LinkOption[0])) {
            throw new IllegalArgumentException("Target folder is not a directory: " + String.valueOf(targetFolder));
        }
        Path path = Files.createTempFile(targetFolder, "truststore-", ".crt", new FileAttribute[0]);
        try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);){
            Enumeration<String> aliases = keyStore.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                Certificate cert = keyStore.getCertificate(alias);
                PemExporter.writeAsPEM(os, cert);
            }
        }
        return path;
    }

    public static Path[] exportKeyPair(KeyStore keyStore, String alias, char[] keyPassword, Path targetFolder) throws Exception {
        Path[] paths;
        block19: {
            OutputStream os;
            block18: {
                if (!Files.isDirectory(targetFolder, new LinkOption[0])) {
                    throw new IllegalArgumentException("Target folder is not a directory: " + String.valueOf(targetFolder));
                }
                paths = new Path[2];
                paths[1] = targetFolder.resolve(alias + ".crt");
                try {
                    os = Files.newOutputStream(paths[1], new OpenOption[0]);
                    try {
                        Certificate[] certChain;
                        for (Certificate cert : certChain = keyStore.getCertificateChain(alias)) {
                            PemExporter.writeAsPEM(os, cert);
                        }
                        Files.setPosixFilePermissions(paths[1], Set.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE));
                    }
                    finally {
                        if (os != null) {
                            os.close();
                        }
                    }
                }
                catch (UnsupportedOperationException e) {
                    if (!LOG.isDebugEnabled()) break block18;
                    LOG.debug("Unable to set Posix file permissions", (Throwable)e);
                }
            }
            paths[0] = targetFolder.resolve(alias + ".key");
            try {
                os = Files.newOutputStream(paths[0], new OpenOption[0]);
                try {
                    Key key = keyStore.getKey(alias, keyPassword);
                    PemExporter.writeAsPEM(os, key);
                    Files.setPosixFilePermissions(paths[0], Set.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE));
                }
                finally {
                    if (os != null) {
                        os.close();
                    }
                }
            }
            catch (UnsupportedOperationException e) {
                if (!LOG.isDebugEnabled()) break block19;
                LOG.debug("Unable to set Posix file permissions", (Throwable)e);
            }
        }
        return paths;
    }

    private static void writeAsPEM(OutputStream outputStream, Key key) throws IOException {
        byte[] encoded = ENCODER.encode(key.getEncoded());
        outputStream.write(BEGIN_KEY);
        outputStream.write(LINE_SEPARATOR);
        outputStream.write(encoded);
        outputStream.write(LINE_SEPARATOR);
        outputStream.write(END_KEY);
        outputStream.write(LINE_SEPARATOR);
    }

    private static void writeAsPEM(OutputStream outputStream, Certificate certificate) throws CertificateEncodingException, IOException {
        byte[] encoded = ENCODER.encode(certificate.getEncoded());
        outputStream.write(BEGIN_CERT);
        outputStream.write(LINE_SEPARATOR);
        outputStream.write(encoded);
        outputStream.write(LINE_SEPARATOR);
        outputStream.write(END_CERT);
        outputStream.write(LINE_SEPARATOR);
    }
}

