/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.quiche.foreign.incubator;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.eclipse.jetty.quic.quiche.QuicheBinding;
import org.eclipse.jetty.quic.quiche.QuicheConfig;
import org.eclipse.jetty.quic.quiche.QuicheConnection;
import org.eclipse.jetty.quic.quiche.foreign.incubator.ForeignIncubatorQuicheConnection;
import org.eclipse.jetty.quic.quiche.foreign.incubator.quiche_h;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForeignIncubatorQuicheBinding
implements QuicheBinding {
    private static final Logger LOG = LoggerFactory.getLogger(ForeignIncubatorQuicheBinding.class);

    public boolean isUsable() {
        try {
            quiche_h.quiche_version();
            return true;
        }
        catch (Throwable x) {
            LOG.debug("foreign incubator quiche binding is not usable", x);
            return false;
        }
    }

    public int priority() {
        return 100;
    }

    public byte[] fromPacket(ByteBuffer packet) {
        return ForeignIncubatorQuicheConnection.fromPacket(packet);
    }

    public QuicheConnection connect(QuicheConfig quicheConfig, InetSocketAddress local, InetSocketAddress peer, int connectionIdLength) throws IOException {
        return ForeignIncubatorQuicheConnection.connect(quicheConfig, local, peer, connectionIdLength);
    }

    public boolean negotiate(QuicheConnection.TokenMinter tokenMinter, ByteBuffer packetRead, ByteBuffer packetToSend) throws IOException {
        return ForeignIncubatorQuicheConnection.negotiate(tokenMinter, packetRead, packetToSend);
    }

    public QuicheConnection tryAccept(QuicheConfig quicheConfig, QuicheConnection.TokenValidator tokenValidator, ByteBuffer packetRead, SocketAddress local, SocketAddress peer) throws IOException {
        return ForeignIncubatorQuicheConnection.tryAccept(quicheConfig, tokenValidator, packetRead, local, peer);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{p=" + this.priority() + " u=" + this.isUsable() + "}";
    }
}

