/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.client;

import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.DatagramChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.util.Map;
import java.util.Objects;
import java.util.function.UnaryOperator;
import org.eclipse.jetty.io.ClientConnector;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.DatagramChannelEndPoint;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ManagedSelector;
import org.eclipse.jetty.quic.client.ClientQuicConnection;
import org.eclipse.jetty.quic.common.QuicConfiguration;

public class QuicClientConnectorConfigurator
extends ClientConnector.Configurator {
    private final QuicConfiguration configuration = new QuicConfiguration();
    private final UnaryOperator<Connection> configurator;

    public QuicClientConnectorConfigurator() {
        this(UnaryOperator.identity());
    }

    public QuicClientConnectorConfigurator(UnaryOperator<Connection> configurator) {
        this.configurator = Objects.requireNonNull(configurator);
        this.configuration.setSessionRecvWindow(0x1000000);
        this.configuration.setBidirectionalStreamRecvWindow(0x800000);
        this.configuration.setDisableActiveMigration(true);
        this.configuration.setVerifyPeerCertificates(true);
    }

    public QuicConfiguration getQuicConfiguration() {
        return this.configuration;
    }

    public boolean isIntrinsicallySecure(ClientConnector clientConnector, SocketAddress address) {
        return true;
    }

    public ClientConnector.Configurator.ChannelWithAddress newChannelWithAddress(ClientConnector clientConnector, SocketAddress address, Map<String, Object> context) throws IOException {
        context.put(QuicConfiguration.CONTEXT_KEY, this.configuration);
        DatagramChannel channel = DatagramChannel.open();
        if (clientConnector.getBindAddress() == null) {
            channel.bind(null);
        }
        return new ClientConnector.Configurator.ChannelWithAddress((SelectableChannel)channel, address);
    }

    public EndPoint newEndPoint(ClientConnector clientConnector, SocketAddress address, SelectableChannel selectable, ManagedSelector selector, SelectionKey selectionKey) {
        return new DatagramChannelEndPoint((DatagramChannel)selectable, selector, selectionKey, clientConnector.getScheduler());
    }

    public Connection newConnection(ClientConnector clientConnector, SocketAddress address, EndPoint endPoint, Map<String, Object> context) {
        return (Connection)this.configurator.apply((Connection)new ClientQuicConnection(clientConnector, endPoint, context));
    }
}

