/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.qpack.internal.instruction;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http3.qpack.Instruction;
import org.eclipse.jetty.http3.qpack.internal.util.NBitIntegerEncoder;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;

public class SetCapacityInstruction
implements Instruction {
    private final int _capacity;

    public SetCapacityInstruction(int capacity) {
        this._capacity = capacity;
    }

    public int getCapacity() {
        return this._capacity;
    }

    @Override
    public void encode(ByteBufferPool.Lease lease) {
        int size = NBitIntegerEncoder.octectsNeeded(5, this._capacity) + 1;
        ByteBuffer buffer = lease.acquire(size, false);
        buffer.put((byte)32);
        NBitIntegerEncoder.encode(buffer, 5, this._capacity);
        BufferUtil.flipToFlush((ByteBuffer)buffer, (int)0);
        lease.append(buffer, true);
    }

    public String toString() {
        return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
    }
}

