/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.client.http.internal;

import org.eclipse.jetty.client.HttpChannel;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpReceiver;
import org.eclipse.jetty.client.HttpSender;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http3.api.Stream;
import org.eclipse.jetty.http3.client.http.internal.HttpConnectionOverHTTP3;
import org.eclipse.jetty.http3.client.http.internal.HttpReceiverOverHTTP3;
import org.eclipse.jetty.http3.client.http.internal.HttpSenderOverHTTP3;
import org.eclipse.jetty.http3.client.internal.HTTP3SessionClient;
import org.eclipse.jetty.http3.internal.HTTP3ErrorCode;

public class HttpChannelOverHTTP3
extends HttpChannel {
    private final HttpConnectionOverHTTP3 connection;
    private final HTTP3SessionClient session;
    private final HttpSenderOverHTTP3 sender;
    private final HttpReceiverOverHTTP3 receiver;
    private Stream stream;

    public HttpChannelOverHTTP3(HttpDestination destination, HttpConnectionOverHTTP3 connection, HTTP3SessionClient session) {
        super(destination);
        this.connection = connection;
        this.session = session;
        this.sender = new HttpSenderOverHTTP3(this);
        this.receiver = new HttpReceiverOverHTTP3(this);
    }

    public HTTP3SessionClient getSession() {
        return this.session;
    }

    public Stream.Client.Listener getStreamListener() {
        return this.receiver;
    }

    protected Connection getConnection() {
        return this.connection;
    }

    protected HttpSender getHttpSender() {
        return this.sender;
    }

    protected HttpReceiver getHttpReceiver() {
        return this.receiver;
    }

    public Stream getStream() {
        return this.stream;
    }

    public void setStream(Stream stream) {
        this.stream = stream;
    }

    public void send(HttpExchange exchange) {
        this.sender.send(exchange);
    }

    public void exchangeTerminated(HttpExchange exchange, Result result) {
        super.exchangeTerminated(exchange, result);
        Stream stream = this.getStream();
        if (stream != null && result.isFailed()) {
            stream.reset(HTTP3ErrorCode.REQUEST_CANCELLED_ERROR.code(), result.getFailure());
        } else {
            this.release();
        }
    }

    public void release() {
        this.setStream(null);
        this.connection.release(this);
    }

    public String toString() {
        return String.format("%s[send=%s,recv=%s]", new Object[]{super.toString(), this.sender, this.receiver});
    }
}

