/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.internal.parser;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http3.internal.parser.BodyParser;
import org.eclipse.jetty.http3.internal.parser.HeaderParser;
import org.eclipse.jetty.http3.internal.parser.ParserListener;

public class UnknownBodyParser
extends BodyParser {
    private long length = -1L;

    public UnknownBodyParser(HeaderParser headerParser, ParserListener listener) {
        super(headerParser, listener);
    }

    @Override
    public BodyParser.Result parse(ByteBuffer buffer) {
        int remaining;
        if (this.length < 0L) {
            this.length = this.getBodyLength();
        }
        if ((long)(remaining = buffer.remaining()) >= this.length) {
            buffer.position(buffer.position() + (int)this.length);
            this.length = -1L;
            return BodyParser.Result.WHOLE_FRAME;
        }
        buffer.position(buffer.limit());
        this.length -= (long)remaining;
        return BodyParser.Result.NO_FRAME;
    }
}

