/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.client.http.internal;

import java.net.SocketAddress;
import java.nio.channels.AsynchronousCloseException;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.client.ConnectionPool;
import org.eclipse.jetty.client.HttpChannel;
import org.eclipse.jetty.client.HttpConnection;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.SendFailure;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http3.client.http.internal.HttpChannelOverHTTP3;
import org.eclipse.jetty.http3.client.internal.HTTP3SessionClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnectionOverHTTP3
extends HttpConnection
implements ConnectionPool.Multiplexable,
ConnectionPool.MaxUsable {
    private static final Logger LOG = LoggerFactory.getLogger(HttpConnectionOverHTTP3.class);
    private final Set<HttpChannel> activeChannels = ConcurrentHashMap.newKeySet();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final HTTP3SessionClient session;

    public HttpConnectionOverHTTP3(HttpDestination destination, HTTP3SessionClient session) {
        super(destination);
        this.session = session;
    }

    public HTTP3SessionClient getSession() {
        return this.session;
    }

    public SocketAddress getLocalSocketAddress() {
        return this.session.getLocalSocketAddress();
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.session.getRemoteSocketAddress();
    }

    public int getMaxMultiplex() {
        return this.getMaxUsageCount();
    }

    public int getMaxUsageCount() {
        return this.session.getMaxLocalStreams();
    }

    protected Iterator<HttpChannel> getHttpChannels() {
        return this.activeChannels.iterator();
    }

    public SendFailure send(HttpExchange exchange) {
        HttpRequest request = exchange.getRequest();
        request.version(HttpVersion.HTTP_3);
        this.normalizeRequest(request);
        HttpChannelOverHTTP3 channel = this.newHttpChannel();
        this.activeChannels.add(channel);
        SendFailure result = this.send(channel, exchange);
        if (result != null) {
            this.activeChannels.remove((Object)channel);
            channel.destroy();
        }
        return result;
    }

    protected HttpChannelOverHTTP3 newHttpChannel() {
        return new HttpChannelOverHTTP3(this.getHttpDestination(), this, this.getSession());
    }

    public void release(HttpChannelOverHTTP3 channel) {
        boolean removed = this.activeChannels.remove((Object)channel);
        if (LOG.isDebugEnabled()) {
            LOG.debug("released {} {}", (Object)removed, (Object)channel);
        }
        if (removed) {
            this.getHttpDestination().release((Connection)this);
        } else {
            channel.destroy();
        }
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public void close() {
        this.close(new AsynchronousCloseException());
    }

    public void close(Throwable failure) {
        if (this.closed.compareAndSet(false, true)) {
            this.getHttpDestination().remove((Connection)this);
            this.abort(failure);
            this.session.goAway(false);
            this.destroy();
        }
    }

    private void abort(Throwable failure) {
        for (HttpChannel channel : this.activeChannels) {
            HttpExchange exchange = channel.getHttpExchange();
            if (exchange == null) continue;
            exchange.getRequest().abort(failure);
        }
        this.activeChannels.clear();
    }

    public boolean onIdleTimeout(long idleTimeout, Throwable failure) {
        if (super.onIdleTimeout(idleTimeout, failure)) {
            this.close(failure);
        }
        return false;
    }

    public String toString() {
        return String.format("%s(closed=%b)[%s]", super.toString(), this.isClosed(), this.session);
    }
}

