/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.operation;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.AccumulatingProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.IThreadListener;
import org.eclipse.jface.util.Policy;
import org.eclipse.pde.api.tools.annotations.NoExtend;
import org.eclipse.pde.api.tools.annotations.NoInstantiate;
import org.eclipse.swt.widgets.Display;

@NoInstantiate
@NoExtend
public class ModalContext {
    private static boolean debug = false;
    private static int modalLevel = 0;
    private static boolean runInSeparateThread = true;

    /*
     * Unable to fully structure code
     */
    public static boolean canProgressMonitorBeUsed(IProgressMonitor monitor1, IProgressMonitor monitor2) {
        if (monitor1 != monitor2) ** GOTO lbl5
        return true;
lbl-1000:
        // 1 sources

        {
            if ((monitor1 = ((ProgressMonitorWrapper)monitor1).getWrappedProgressMonitor()) != monitor2) continue;
            return true;
lbl5:
            // 2 sources

            ** while (monitor1 instanceof ProgressMonitorWrapper)
        }
lbl6:
        // 1 sources

        return false;
    }

    public static void checkCanceled(IProgressMonitor monitor) throws InterruptedException {
        if (monitor.isCanceled()) {
            throw new InterruptedException();
        }
    }

    private static ModalContextThread getCurrentModalContextThread() {
        Thread t = Thread.currentThread();
        if (t instanceof ModalContextThread) {
            return (ModalContextThread)t;
        }
        return null;
    }

    public static int getModalLevel() {
        return modalLevel;
    }

    public static boolean isModalContextThread(Thread thread) {
        return thread instanceof ModalContextThread;
    }

    public static void run(IRunnableWithProgress operation, boolean fork, IProgressMonitor monitor, Display display) throws InvocationTargetException, InterruptedException {
        Assert.isTrue((operation != null && monitor != null ? 1 : 0) != 0);
        ++modalLevel;
        try {
            monitor.setCanceled(false);
            if (!fork || !runInSeparateThread) {
                ModalContext.runInCurrentThread(operation, monitor);
            } else {
                ModalContextThread t = ModalContext.getCurrentModalContextThread();
                if (t != null) {
                    Assert.isTrue((boolean)ModalContext.canProgressMonitorBeUsed(monitor, t.progressMonitor));
                    ModalContext.runInCurrentThread(operation, monitor);
                } else {
                    t = new ModalContextThread(operation, monitor, display);
                    Throwable listenerException = null;
                    if (operation instanceof IThreadListener) {
                        listenerException = ModalContext.invokeThreadListener((IThreadListener)((Object)operation), t);
                    }
                    if (listenerException == null) {
                        t.start();
                        t.block();
                    } else if (t.throwable == null) {
                        t.throwable = listenerException;
                    }
                    Throwable throwable = t.throwable;
                    if (throwable != null) {
                        if (debug && !(throwable instanceof InterruptedException) && !(throwable instanceof OperationCanceledException)) {
                            System.err.println("Exception in modal context operation:");
                            throwable.printStackTrace();
                            System.err.println("Called from:");
                            new InvocationTargetException(null).printStackTrace();
                        }
                        if (throwable instanceof InvocationTargetException) {
                            InvocationTargetException e = (InvocationTargetException)throwable;
                            throw e;
                        }
                        if (throwable instanceof InterruptedException) {
                            InterruptedException e = (InterruptedException)throwable;
                            throw e;
                        }
                        if (throwable instanceof OperationCanceledException) {
                            InterruptedException interruptedException = new InterruptedException(throwable.getMessage());
                            interruptedException.initCause(throwable);
                            throw interruptedException;
                        }
                        throw new InvocationTargetException(throwable);
                    }
                }
            }
        }
        finally {
            --modalLevel;
        }
    }

    static Throwable invokeThreadListener(IThreadListener listener, Thread switchingThread) {
        try {
            listener.threadChange(switchingThread);
        }
        catch (Error | RuntimeException e) {
            return e;
        }
        return null;
    }

    private static void runInCurrentThread(IRunnableWithProgress runnable, IProgressMonitor progressMonitor) throws InterruptedException, InvocationTargetException {
        try {
            if (runnable != null) {
                runnable.run(progressMonitor);
            }
        }
        catch (OperationCanceledException e) {
            InterruptedException interruptedException = new InterruptedException(e.getLocalizedMessage());
            interruptedException.initCause(e);
            throw interruptedException;
        }
        catch (InterruptedException | InvocationTargetException e) {
            throw e;
        }
        catch (Error | RuntimeException e) {
            throw new InvocationTargetException(e);
        }
    }

    public static void setDebugMode(boolean debugMode) {
        debug = debugMode;
    }

    public static void setAllowReadAndDispatch(boolean allowReadAndDispatch) {
        runInSeparateThread = allowReadAndDispatch;
    }

    private static class ModalContextThread
    extends Thread {
        private final IRunnableWithProgress runnable;
        private Throwable throwable;
        private final IProgressMonitor progressMonitor;
        private final Display display;
        private volatile boolean continueEventDispatching = true;
        private final Thread callingThread;

        private ModalContextThread(IRunnableWithProgress operation, IProgressMonitor monitor, Display display) {
            super("ModalContext");
            Assert.isTrue((monitor != null && display != null ? 1 : 0) != 0);
            this.runnable = operation;
            this.progressMonitor = new AccumulatingProgressMonitor(monitor, display);
            this.display = display;
            this.callingThread = Thread.currentThread();
        }

        @Override
        public void run() {
            block9: {
                Throwable exception;
                try {
                    try {
                        if (this.runnable != null) {
                            this.runnable.run(this.progressMonitor);
                        }
                    }
                    catch (Error | InterruptedException | RuntimeException | InvocationTargetException e) {
                        Throwable exception2;
                        this.throwable = e;
                        this.progressMonitor.done();
                        if (this.runnable instanceof IThreadListener && (exception2 = ModalContext.invokeThreadListener((IThreadListener)((Object)this.runnable), this.callingThread)) != null && this.throwable == null) {
                            this.throwable = exception2;
                        }
                        this.display.syncExec(() -> {});
                        this.continueEventDispatching = false;
                        this.display.asyncExec(null);
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    Throwable exception3;
                    this.progressMonitor.done();
                    if (this.runnable instanceof IThreadListener && (exception3 = ModalContext.invokeThreadListener((IThreadListener)((Object)this.runnable), this.callingThread)) != null && this.throwable == null) {
                        this.throwable = exception3;
                    }
                    this.display.syncExec(() -> {});
                    this.continueEventDispatching = false;
                    this.display.asyncExec(null);
                    throw throwable;
                }
                this.progressMonitor.done();
                if (this.runnable instanceof IThreadListener && (exception = ModalContext.invokeThreadListener((IThreadListener)((Object)this.runnable), this.callingThread)) != null && this.throwable == null) {
                    this.throwable = exception;
                }
                this.display.syncExec(() -> {});
                this.continueEventDispatching = false;
                this.display.asyncExec(null);
            }
        }

        public void block() {
            if (this.display == Display.getCurrent()) {
                int exceptionCount = 0;
                while (this.continueEventDispatching) {
                    try {
                        if (!this.display.readAndDispatch()) {
                            this.display.sleep();
                        }
                        exceptionCount = 0;
                    }
                    catch (Throwable t) {
                        if (t instanceof VirtualMachineError) {
                            throw (VirtualMachineError)t;
                        }
                        if (++exceptionCount > 50 || this.display.isDisposed()) {
                            if (t instanceof RuntimeException) {
                                throw (RuntimeException)t;
                            }
                            if (t instanceof Error) {
                                throw (Error)t;
                            }
                            throw new RuntimeException(t);
                        }
                        Policy.getLog().log(Status.error((String)"Unhandled event loop exception during blocked modal context.", (Throwable)t));
                    }
                }
            } else {
                try {
                    this.join();
                }
                catch (InterruptedException e) {
                    this.throwable = e;
                }
            }
        }
    }
}

