/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.auth.AccessController;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.DestinationList;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.Producer;
import com.sun.messaging.jmq.jmsserver.core.ProducerUID;
import com.sun.messaging.jmq.jmsserver.core.Session;
import com.sun.messaging.jmq.jmsserver.core.SessionUID;
import com.sun.messaging.jmq.jmsserver.core.StringUID;
import com.sun.messaging.jmq.jmsserver.data.RollbackReason;
import com.sun.messaging.jmq.jmsserver.data.TransactionList;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.handlers.TransactionHandler;
import com.sun.messaging.jmq.jmsserver.persist.api.PartitionedStore;
import com.sun.messaging.jmq.jmsserver.plugin.spi.ConsumerSpi;
import com.sun.messaging.jmq.jmsserver.plugin.spi.CoreLifecycleSpi;
import com.sun.messaging.jmq.jmsserver.plugin.spi.ProducerSpi;
import com.sun.messaging.jmq.jmsserver.service.Connection;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.MetricCounters;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.admin.ConnectionInfo;
import com.sun.messaging.jmq.util.lists.EventListener;
import com.sun.messaging.jmq.util.lists.EventType;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public abstract class IMQConnection
extends Connection
implements EventListener {
    public static final boolean DEBUG_TXN = Globals.getConfig().getBooleanProperty("imq.cluster.debug.txn");
    private String destroyReason = null;
    protected int msgsToConsumer = 0;
    protected int msgsIn = 0;
    private int pauseFlowCnt = 0;
    private int resumeFlowCnt = 0;
    boolean BLOCKING = false;
    private Set tmpDestinations = Collections.synchronizedSet(new HashSet());
    public static final String CLIENT_ID = "client id";
    public static final String TRANSACTION_LIST = "transaction";
    public static final String TRANSACTION_IDMAP = "tidmap";
    public static final String TRANSACTION_CACHE = "txncache";
    public static final String USER_AGENT = "useragent";
    static boolean DEBUG = Globals.getConfig().getBooleanProperty("imq.packet.debug.info");
    protected MetricCounters counters = new MetricCounters();
    ConnectionInfo coninfo;
    byte[] empty = new byte[]{0};
    byte[] remoteIP = this.empty;
    protected PartitionedStore pstore = null;
    protected boolean runningMsgs = false;
    protected boolean paused = false;
    protected boolean waitingForResumeFlow = false;
    protected int flowCount = 0;
    protected int sent_count = 0;
    Object stateLock = new Object();
    boolean busy = false;
    HashMap producers = new HashMap();
    HashMap sessions = new HashMap();
    HashMap lockToSession = new HashMap();
    Set busySessions = Collections.synchronizedSet(new LinkedHashSet());

    public void setDestroyReason(String r) {
        this.destroyReason = r;
    }

    public String getDestroyReason() {
        return this.destroyReason;
    }

    @Override
    public void debug(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        this.dumpState();
        Iterator itr = this.sessions.values().iterator();
        while (itr.hasNext()) {
            ((Session)itr.next()).debug("  ");
        }
    }

    protected IMQConnection(Service svc) throws BrokerException {
        super(svc);
        this.setConnectionUID(new ConnectionUID());
        this.accessController = AccessController.getInstance(svc.getName(), svc.getServiceType());
        this.sessions = new HashMap();
    }

    public UID attachStorePartition(UID storeSession) throws BrokerException {
        Globals.getDestinationList();
        this.pstore = DestinationList.assignStorePartition(this.getService().getServiceType(), this.getConnectionUID(), storeSession);
        return this.pstore.getPartitionID();
    }

    public PartitionedStore getPartitionedStore() {
        return this.pstore;
    }

    public void dumpState() {
        this.logger.log(8, "Dumping state of " + String.valueOf(this));
        this.logger.log(8, "\tsessions = " + this.sessions.size());
        this.logger.log(8, "\tbusySessions = " + this.busySessions.size());
        this.logger.log(8, "\trunningMsgs = " + this.runningMsgs);
        this.logger.log(8, "\tpaused = " + this.paused);
        this.logger.log(8, "\twaitingForResumeFlow = " + this.waitingForResumeFlow);
    }

    public boolean isBlocking() {
        return this.BLOCKING;
    }

    public void dump() {
        this.logger.log(8, "DUMPING CONNECTION " + String.valueOf(this));
        this.dumpState();
        this.logger.log(8, "Sessions (size) :" + this.sessions.size());
        this.logger.log(8, "Sessions (list) :" + String.valueOf(this.sessions));
        this.logger.log(8, "Busy (size) :" + this.busySessions.size());
        this.logger.log(8, "Busy (list) :" + String.valueOf(this.busySessions));
        this.logger.log(8, "----------- sessions -----------");
        Iterator itr = this.sessions.values().iterator();
        while (itr.hasNext()) {
            ((Session)itr.next()).dump("\t");
        }
        this.logger.log(8, "----------- busy sessions -----------");
        itr = this.sessions.values().iterator();
        while (itr.hasNext()) {
            this.logger.log(8, "\t" + ((Session)itr.next()).toString());
        }
    }

    @Override
    public synchronized Hashtable getDebugState() {
        Vector<String> v;
        Hashtable ht = super.getDebugState();
        ht.put("pauseFlowCnt", String.valueOf(this.pauseFlowCnt));
        ht.put("resumeFlowCnt", String.valueOf(this.resumeFlowCnt));
        ht.put("producerCnt", String.valueOf(this.producers.size()));
        if (this.producers.size() > 0) {
            v = new Vector<String>();
            for (Object p : this.producers.keySet()) {
                v.add(((UID)p).toString());
            }
            ht.put("producers", v);
        }
        ht.put("msgsToConsumer", String.valueOf(this.msgsToConsumer));
        ht.put("sessionCnt", String.valueOf(this.sessions.size()));
        if (this.sessions.size() > 0) {
            v = new Vector();
            for (Object p : this.sessions.values()) {
                v.add(((Session)p).getSessionUID().toString());
            }
            ht.put("sessions", v);
        }
        ht.put("busySessionCnt", String.valueOf(this.busySessions.size()));
        if (this.busySessions.size() > 0) {
            v = new Vector();
            for (Object p : this.busySessions) {
                v.add(((Session)p).getSessionUID().toString());
            }
            ht.put("busySessions", v);
        }
        ht.put("tempDestCnt", String.valueOf(this.tmpDestinations.size()));
        if (this.tmpDestinations.size() > 0) {
            v = new Vector();
            for (Object p : this.tmpDestinations) {
                v.add(((StringUID)p).toString());
            }
            ht.put("tempDestinations", v);
        }
        ht.put("runningMsgs", String.valueOf(this.runningMsgs));
        ht.put("paused", String.valueOf(this.paused));
        ht.put("waitingForResumeFlow", String.valueOf(this.waitingForResumeFlow));
        ht.put("flowCount", String.valueOf(this.flowCount));
        ht.put("sentCount", String.valueOf(this.sent_count));
        ht.put("userName", this.getUserName());
        ht.put("remoteString", this.getRemoteConnectionString());
        return ht;
    }

    public Vector getDebugMessages(boolean full) {
        Vector ht = new Vector();
        return ht;
    }

    public void setRemoteIP(byte[] remoteIP) {
        this.remoteIP = remoteIP;
        if (this.coninfo != null) {
            this.coninfo.remoteIP = remoteIP;
        }
    }

    public byte[] getRemoteIP() {
        return this.remoteIP;
    }

    public void resetCounters() {
        this.counters = new MetricCounters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionInfo getConnectionInfo() {
        if (this.coninfo == null) {
            this.coninfo = new ConnectionInfo();
            this.coninfo.id = this.conId == null ? this.empty : this.conId.toString().getBytes();
            this.coninfo.remoteIP = this.remoteIP;
            this.coninfo.service = this.service.getName();
        }
        this.coninfo.user = null;
        Principal principal = null;
        try {
            principal = this.getAuthenticatedName();
            if (principal != null) {
                this.coninfo.user = principal.getName();
            }
        }
        catch (BrokerException e) {
            this.logger.log(4, "Exception getting authentication name " + String.valueOf(this.conId));
            this.coninfo.user = e.getMessage();
        }
        this.coninfo.uuid = this.conId.longValue();
        this.coninfo.metrics = (MetricCounters)this.counters.clone();
        this.coninfo.clientID = (String)this.getClientData(CLIENT_ID);
        this.coninfo.nproducers = this.producers.size();
        this.coninfo.userAgent = (String)this.getClientData(USER_AGENT);
        if (this.coninfo.userAgent == null) {
            this.coninfo.userAgent = "";
        }
        int cnt = 0;
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            Iterator itr = this.sessions.values().iterator();
            while (itr.hasNext()) {
                cnt += ((Session)itr.next()).getConsumerCnt();
            }
        }
        this.coninfo.nconsumers = cnt;
        return this.coninfo;
    }

    public MetricCounters getMetricCounters() {
        return this.counters;
    }

    public abstract boolean useDirectBuffers();

    public boolean isValid() {
        return this.getConnectionState() < 7;
    }

    public boolean isAuthenticated() {
        return this.getConnectionState() == 4;
    }

    public boolean isStarted() {
        return this.getConnectionState() > 1;
    }

    public boolean isBeingDestroyed() {
        return this.getConnectionState() > 4;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Connection) {
            return ((Connection)obj).getConnectionUID().equals(this.getConnectionUID());
        }
        return false;
    }

    public int hashCode() {
        if (this.conId == null) {
            return 0;
        }
        return this.conId.hashCode();
    }

    public String toString() {
        return "IMQConn[" + IMQConnection.getConnectionStateString(this.state) + "," + this.getRemoteConnectionString() + "," + this.localServiceString() + "]";
    }

    public String toDebugString() {
        return super.toString() + " state: " + this.state;
    }

    public abstract String remoteHostString();

    @Override
    public abstract String getRemoteConnectionString();

    protected abstract String localServiceString();

    public String getUserName() {
        String userString = "???";
        try {
            Principal principal = this.getAuthenticatedName();
            if (principal != null) {
                userString = principal.getName();
            }
        }
        catch (BrokerException e) {
            this.logger.log(4, "Exception getting authentication name " + String.valueOf(this.conId), e);
        }
        return userString;
    }

    public String userReadableString() {
        return this.getRemoteConnectionString() + "->" + this.localServiceString();
    }

    public void setFlowCount(int count) {
        this.flowCount = count;
    }

    public int getFlowCount() {
        return this.flowCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeFlow(int count) {
        this.sent_count = 0;
        if (count != -1) {
            this.setFlowCount(count);
        }
        Object object = this.stateLock;
        synchronized (object) {
            this.waitingForResumeFlow = false;
            ++this.resumeFlowCnt;
            this.checkState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void haltFlow() {
        Object object = this.stateLock;
        synchronized (object) {
            this.waitingForResumeFlow = true;
            ++this.pauseFlowCnt;
            this.checkState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startConnection() {
        Object object = this.stateLock;
        synchronized (object) {
            this.runningMsgs = true;
            this.checkState();
            Globals.getConnectionManager().getConsumerInfoNotifyManager().connectionStarted(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectionStarted() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.runningMsgs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopConnection() {
        Object object = this.stateLock;
        synchronized (object) {
            this.runningMsgs = false;
            this.checkState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() {
        Object object = this.stateLock;
        synchronized (object) {
            this.paused = true;
            this.checkState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() {
        Object object = this.stateLock;
        synchronized (object) {
            this.paused = false;
            this.checkState();
        }
    }

    @Override
    public synchronized void cleanupConnection() {
        boolean successful = false;
        try {
            if (this.state >= 5) {
                this.wakeup();
                successful = true;
                return;
            }
            if (this.state < 5) {
                this.state = 5;
            }
            this.stopConnection();
            this.cleanup(false);
            this.wakeup();
            successful = true;
        }
        finally {
            if (!successful) {
                this.state = 4;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanup(boolean shutdown) {
        try {
            if (!shutdown) {
                this.cleanUpConsumers();
                this.cleanUpProducers();
            }
            this.cleanUpTransactions();
            this.lockToSession.clear();
            this.sessions.clear();
            this.busySessions.clear();
            this.cleanUpTempDest(shutdown);
            this.cleanupControlPackets(shutdown);
        }
        finally {
            try {
                Globals.getDestinationList();
                DestinationList.unassignStorePartition(this.getConnectionUID(), this.pstore);
            }
            finally {
                Globals.getClusterBroadcast().connectionClosed(this.getConnectionUID(), this.isAdminConnection());
            }
        }
    }

    protected abstract void cleanupControlPackets(boolean var1);

    private synchronized void cleanUpTransactions() {
        this.logger.log(4, "Cleaning up transactions on connection " + String.valueOf(this));
        List conlist = (List)this.getClientData(TRANSACTION_LIST);
        if (conlist != null) {
            boolean xaretainall = Globals.getConfig().getBooleanProperty("imq.transaction.detachedRetainAll", false);
            ArrayList<TransactionUID> timeoutTIDs = new ArrayList<TransactionUID>();
            TransactionUID tid2 = null;
            boolean xaretainallLogged = false;
            TransactionHandler rollbackHandler = (TransactionHandler)Globals.getPacketRouter(0).getHandler(48);
            Globals.getDestinationList();
            TransactionList[] tls = DestinationList.getTransactionList(this.pstore);
            TransactionList tl = tls[0];
            TransactionUID[] tuids = conlist.toArray(new TransactionUID[conlist.size()]);
            for (int i = 0; i < tuids.length; ++i) {
                Object[] args;
                tid2 = tuids[i];
                TransactionState ts = tl.retrieveState(tid2);
                if (ts == null) continue;
                int tstate = ts.getState();
                if (tstate == 5 && ts.getOnephasePrepare()) {
                    ts.detachedFromConnection();
                    timeoutTIDs.add(tid2);
                    args = new String[]{String.valueOf(tid2) + "(XID=" + String.valueOf(ts.getXid()) + ")", TransactionState.toString(tstate) + "[onephase=true]", this.getConnectionUID().toString()};
                    this.logger.log(8, Globals.getBrokerResources().getKString("B1266", args));
                    continue;
                }
                if (ts.getXid() != null) {
                    if (xaretainall) {
                        if (xaretainallLogged) continue;
                        this.logger.log(8, Globals.getBrokerResources().getKString("B1282"));
                        xaretainallLogged = true;
                        continue;
                    }
                    if (tstate > 4) {
                        args = new String[]{String.valueOf(tid2) + "(XID=" + String.valueOf(ts.getXid()) + ")", TransactionState.toString(tstate), this.getConnectionUID().toString()};
                        this.logger.log(8, Globals.getBrokerResources().getKString("B1266", args));
                        continue;
                    }
                    if (tstate == 3 || tstate == 4) {
                        ts.detachedFromConnection();
                        timeoutTIDs.add(tid2);
                        args = new String[]{String.valueOf(tid2) + "(XID=" + String.valueOf(ts.getXid()) + ")", TransactionState.toString(tstate), this.getConnectionUID().toString()};
                        this.logger.log(8, Globals.getBrokerResources().getKString("B1266", args));
                        continue;
                    }
                }
                if (tstate == 5 || tstate == 6 || tstate == 7) {
                    args = new String[]{String.valueOf(tid2), TransactionState.toString(tstate), this.getConnectionUID().toString()};
                    this.logger.log(8, Globals.getBrokerResources().getKString("B1266", args));
                    continue;
                }
                if (DEBUG || DEBUG_TXN) {
                    this.logger.log(8, "Cleanup connection [" + String.valueOf(this.getConnectionUID()) + "]: cleaning up transaction " + String.valueOf(tid2) + "[" + TransactionState.toString(tstate) + "]");
                }
                try {
                    rollbackHandler.doRollback(tl, tid2, ts.getXid(), null, ts, conlist, null, RollbackReason.CONNECTION_CLEANUP);
                    continue;
                }
                catch (Exception e) {
                    Object[] args2 = new String[]{String.valueOf(tid2) + "[" + TransactionState.toString(tstate) + "]", this.getConnectionUID().toString(), e.getMessage()};
                    this.logger.logStack(16, Globals.getBrokerResources().getString("B2182", args2), e);
                }
            }
            for (TransactionUID tid2 : timeoutTIDs) {
                tl.addDetachedTransactionID(tid2);
            }
            timeoutTIDs.clear();
            conlist.clear();
        }
    }

    @Override
    public synchronized void shutdownConnection(String reason) {
        if (DEBUG) {
            this.logger.log(2, "Shuting down Connection {0}", this.toString());
        }
        this.closeConnection(true, 1, reason);
        this.destroyConnection(true, 1, reason);
    }

    @Override
    public void setConnectionUID(ConnectionUID id) {
        this.conId = id;
        if (this.coninfo != null) {
            this.coninfo.id = id.toString().getBytes();
        }
    }

    public abstract void sendControlMessage(Packet var1);

    protected abstract void checkState();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeup() {
        Object object = this.stateLock;
        synchronized (object) {
            this.stateLock.notifyAll();
        }
    }

    public boolean isBusy() {
        return this.busy;
    }

    @Override
    public void cleanupMemory(boolean persist) {
    }

    public void flowPaused(long size) {
    }

    public void addProducer(ProducerSpi p) {
        if (Globals.getMemManager() != null) {
            Globals.getMemManager().addProducer();
        }
        ProducerSpi old = this.producers.put(p.getProducerUID(), p);
        assert (old == null);
    }

    public void removeProducer(ProducerUID pid, String reason, CoreLifecycleSpi clc) throws BrokerException {
        Object o;
        if (Globals.getMemManager() != null) {
            Globals.getMemManager().removeProducer();
        }
        if ((o = this.producers.remove(pid)) == null) {
            throw new BrokerException("Requested removal of  producer " + String.valueOf(pid) + " which is not associated with connection " + String.valueOf(this.getConnectionUID()));
        }
        clc.destroyProducer(pid, reason);
    }

    public List getSessions() {
        return new ArrayList(this.sessions.keySet());
    }

    public List getProducers() {
        return new ArrayList(this.producers.values());
    }

    public List getProducerIDs() {
        return new ArrayList(this.producers.keySet());
    }

    public int getProducerCnt() {
        return this.producers.size();
    }

    public List getConsumers() {
        ArrayList<ConsumerSpi> cons = new ArrayList<ConsumerSpi>();
        for (Session s : this.sessions.values()) {
            Iterator citr = s.getConsumers();
            while (citr.hasNext()) {
                ConsumerSpi c = (ConsumerSpi)citr.next();
                cons.add(c);
            }
        }
        return cons;
    }

    public List getConsumersIDs() {
        ArrayList<ConsumerUID> cons = new ArrayList<ConsumerUID>();
        for (Session s : this.sessions.values()) {
            Iterator citr = s.getConsumers();
            while (citr.hasNext()) {
                ConsumerSpi c = (ConsumerSpi)citr.next();
                cons.add(c.getConsumerUID());
            }
        }
        return cons;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpProducers() {
        if (Globals.getMemManager() != null) {
            Globals.getMemManager().removeProducer(this.producers.size());
        }
        HashMap hashMap = this.producers;
        synchronized (hashMap) {
            Iterator itr = this.producers.values().iterator();
            while (itr.hasNext()) {
                ProducerSpi p = (ProducerSpi)itr.next();
                if (this.coreLifecycle != null) {
                    this.coreLifecycle.destroyProducer(p.getProducerUID(), "cleanup of connection " + String.valueOf(this));
                } else {
                    Producer.destroyProducer(p.getProducerUID(), "cleanup of connection " + String.valueOf(this));
                }
                itr.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanUpConsumers() {
        Iterator keys = null;
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            keys = new HashSet(this.sessions.keySet()).iterator();
        }
        while (keys.hasNext()) {
            SessionUID key = (SessionUID)keys.next();
            try {
                this.closeSession(key);
            }
            catch (BrokerException brokerException) {}
        }
        this.sessions.clear();
        this.busySessions.clear();
    }

    public boolean hasBusySessions() {
        return this.busySessions.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Session getSession(SessionUID uid) {
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            return (Session)this.sessions.get(uid);
        }
    }

    public void attachTempDestination(DestinationUID d) {
        this.tmpDestinations.add(d);
    }

    public void detachTempDestination(DestinationUID d) {
        this.tmpDestinations.remove(d);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUpTempDest(boolean shutdown) {
        if (shutdown && this.getConnectionUID().getCanReconnect()) {
            return;
        }
        Set set = this.tmpDestinations;
        synchronized (set) {
            for (DestinationUID uid : this.tmpDestinations) {
                this.logger.log(4, "Destroying temp destination " + String.valueOf(uid) + " on connection death");
                try {
                    if (this.coreLifecycle != null) {
                        this.coreLifecycle.removeDestination(this.pstore, uid, true, Globals.getBrokerResources().getString("B0068", this.getConnectionUID()));
                        continue;
                    }
                    Globals.getDestinationList();
                    DestinationList.removeDestination(this.pstore, uid, true, Globals.getBrokerResources().getString("B0068", this.getConnectionUID()));
                }
                catch (Exception ex) {
                    this.logger.log(8, "Error destination temp  destination " + String.valueOf(uid));
                }
            }
            this.tmpDestinations.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attachSession(Session s) {
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            this.sessions.put(s.getSessionUID(), s);
            this.lockToSession.put(s.getSessionUID(), s.addEventListener(this, EventType.BUSY_STATE_CHANGED, null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSession(SessionUID uid) throws BrokerException {
        HashMap hashMap = this.sessions;
        synchronized (hashMap) {
            Session s = (Session)this.sessions.remove(uid);
            if (s == null) {
                throw new BrokerException("Requested removal of  session " + String.valueOf(uid) + " which is not associated with connection " + String.valueOf(this.getConnectionUID()));
            }
            if (this.lockToSession != null) {
                this.lockToSession.remove(s.getSessionUID());
            }
        }
        Session.closeSession(uid);
    }

    public void destroy(boolean goodbye, int reason, String str) {
        this.destroyConnection(goodbye, reason, str);
    }

    public synchronized List getTransactionListThreadSafe() {
        List conlist = (List)this.getClientData(TRANSACTION_LIST);
        if (conlist == null) {
            conlist = Collections.synchronizedList(new ArrayList());
            this.addClientData(TRANSACTION_LIST, conlist);
        }
        return conlist;
    }
}

