/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.objects;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.orion.server.core.resources.Property;
import org.eclipse.orion.server.core.resources.ResourceShape;
import org.eclipse.orion.server.core.resources.annotations.PropertyDescription;
import org.eclipse.orion.server.core.resources.annotations.ResourceDescription;
import org.eclipse.orion.server.git.objects.GitObject;
import org.eclipse.orion.server.git.servlets.GitUtils;
import org.json.JSONException;
import org.json.JSONObject;

@ResourceDescription(type="Tag")
public class Tag
extends GitObject {
    public static final String RESOURCE = "tag";
    public static final String TYPE = "Tag";
    public static final Comparator<Tag> COMPARATOR = new Comparator<Tag>(){

        @Override
        public int compare(Tag o1, Tag o2) {
            return o1.getTime() < o2.getTime() ? 1 : (o1.getTime() > o2.getTime() ? -1 : o2.getName(false, false).compareTo(o1.getName(false, false)));
        }
    };
    private static final ResourceShape DEFAULT_RESOURCE_SHAPE = new ResourceShape();
    private RevTag tag;
    private Ref ref;
    private URI tagLocation;
    private URI commitLocation;
    private RevCommit commit;

    public Tag(URI cloneLocation, Repository db, Ref ref) throws IOException, CoreException {
        super(cloneLocation, db);
        Property[] defaultProperties = new Property[]{new Property("Location"), new Property("CloneLocation"), new Property("Name"), new Property("CommitLocation"), new Property("TreeLocation"), new Property("LocalTimeStamp"), new Property("TagType"), new Property("FullName")};
        DEFAULT_RESOURCE_SHAPE.setProperties(defaultProperties);
        this.ref = ref;
    }

    @Override
    public JSONObject toJSON() throws JSONException, URISyntaxException, IOException, CoreException {
        return (JSONObject)this.jsonSerializer.serialize((Object)this, DEFAULT_RESOURCE_SHAPE);
    }

    @PropertyDescription(name="Name")
    private String getName() {
        return this.getName(false, false);
    }

    @PropertyDescription(name="TagType")
    private TagType getTagType() {
        return TagType.valueOf(this);
    }

    @PropertyDescription(name="FullName")
    private String getFullName() {
        return this.getName(true, false);
    }

    private RevTag parseTag() {
        this.parseCommit();
        return this.tag;
    }

    private RevCommit parseCommit() {
        if (this.commit == null) {
            RevWalk rw = new RevWalk(this.db);
            try {
                try {
                    RevObject any = rw.parseAny((AnyObjectId)this.ref.getObjectId());
                    if (any instanceof RevTag) {
                        this.tag = (RevTag)any;
                        RevObject o = rw.peel(any);
                        if (o instanceof RevCommit) {
                            this.commit = (RevCommit)rw.peel(any);
                        }
                    } else if (any instanceof RevCommit) {
                        this.commit = (RevCommit)any;
                    }
                }
                catch (IOException iOException) {
                    rw.dispose();
                }
            }
            finally {
                rw.dispose();
            }
        }
        return this.commit;
    }

    public JSONObject toJSON(JSONObject log) throws JSONException, URISyntaxException, IOException, CoreException {
        JSONObject tagJSON = this.toJSON();
        tagJSON.put("Commit", (Object)log);
        return tagJSON;
    }

    private String getName(boolean fullName, boolean encode) {
        String name = null;
        if (this.tag != null) {
            String string = name = fullName ? "refs/tags/" + this.tag.getTagName() : this.tag.getTagName();
        }
        if (this.ref != null) {
            String string = name = fullName ? this.ref.getName() : Repository.shortenRefName((String)this.ref.getName());
        }
        if (name == null) {
            return null;
        }
        if (encode) {
            name = GitUtils.encode(name);
        }
        return name;
    }

    @Override
    protected URI getLocation() throws URISyntaxException {
        if (this.tagLocation == null) {
            Path p = new Path(this.cloneLocation.getPath());
            p = p.uptoSegment(1).append(RESOURCE).append(this.getName(false, true)).addTrailingSeparator().append(p.removeFirstSegments(2));
            this.tagLocation = new URI(this.cloneLocation.getScheme(), this.cloneLocation.getUserInfo(), this.cloneLocation.getHost(), this.cloneLocation.getPort(), p.toString(), this.cloneLocation.getQuery(), this.cloneLocation.getFragment());
        }
        return this.tagLocation;
    }

    @PropertyDescription(name="CommitLocation")
    private URI getCommitLocation() throws URISyntaxException {
        if (this.commitLocation == null && this.commit != null) {
            Path p = new Path(this.cloneLocation.getPath());
            p = p.uptoSegment(1).append("commit").append(this.parseCommit().getName()).addTrailingSeparator().append(p.removeFirstSegments(2));
            this.commitLocation = new URI(this.cloneLocation.getScheme(), this.cloneLocation.getUserInfo(), this.cloneLocation.getHost(), this.cloneLocation.getPort(), p.toString(), this.cloneLocation.getQuery(), this.cloneLocation.getFragment());
        }
        return this.commitLocation;
    }

    @PropertyDescription(name="TreeLocation")
    private URI getTreeLocation() throws URISyntaxException {
        return this.createTreeLocation(null);
    }

    private URI createTreeLocation(String path) throws URISyntaxException {
        IPath clonePath = new Path(this.cloneLocation.getPath()).removeFirstSegments(2);
        IPath result = new Path("/gitapi").append("tree").append(clonePath).append(GitUtils.encode(this.getName()));
        if (path != null) {
            result.append(path);
        }
        return new URI(this.cloneLocation.getScheme(), this.cloneLocation.getUserInfo(), this.cloneLocation.getHost(), this.cloneLocation.getPort(), result.makeAbsolute().toString(), this.cloneLocation.getQuery(), this.cloneLocation.getFragment());
    }

    @PropertyDescription(name="LocalTimeStamp")
    private long getTime() {
        RevCommit c = this.parseCommit();
        if (c != null) {
            return (long)c.getCommitTime() * 1000L;
        }
        return 0L;
    }

    public String getRevCommitName() {
        RevCommit c = this.parseCommit();
        if (c == null) {
            return null;
        }
        return this.parseCommit().getName();
    }

    private static enum TagType {
        LIGHTWEIGHT,
        ANNOTATED;


        public static TagType valueOf(String string) {
            return Enum.valueOf(TagType.class, string);
        }
    }
}

