/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.core.resources;

import org.eclipse.orion.server.core.resources.Base64;

public class Base64Counter {
    private byte[] counter = new byte[6];

    public Base64Counter() {
    }

    public Base64Counter(String start) {
        if (start.length() > 8) {
            throw new IllegalArgumentException("This counter only supports numbers up to 2^48");
        }
        String encoding = start;
        while (encoding.length() < 8) {
            encoding = "A" + encoding;
        }
        this.counter = Base64.decode(encoding.getBytes());
        if (this.counter.length != 6) {
            throw new IllegalArgumentException("The input was not a valid base 64 string: " + start);
        }
    }

    public void increment() {
        int position = 5;
        while (position >= 0) {
            int n = position--;
            this.counter[n] = (byte)(this.counter[n] + 1);
            if (this.counter[n] != 0) break;
        }
    }

    public long count() {
        int position = 5;
        long count = 0L;
        while (position <= 5) {
            count = (count << 8) + ((long)this.counter[position++] & 0xFFL);
        }
        return count;
    }

    public String toString() {
        byte[] result = Base64.encode(this.counter);
        int sigDigit = 0;
        while (sigDigit < 8 && result[sigDigit] == 65) {
            ++sigDigit;
        }
        return sigDigit == 8 ? "A" : new String(result, sigDigit, 8 - sigDigit);
    }
}

