/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.objects;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.orion.server.core.resources.Property;
import org.eclipse.orion.server.core.resources.ResourceShape;
import org.eclipse.orion.server.core.resources.annotations.PropertyDescription;
import org.eclipse.orion.server.core.resources.annotations.ResourceDescription;
import org.eclipse.orion.server.git.objects.GitObject;
import org.json.JSONException;
import org.json.JSONObject;

@ResourceDescription(type="PullRequest")
public class PullRequest
extends GitObject {
    public static final String RESOURCE = "pullRequest";
    public static final String TYPE = "PullRequest";
    private JSONObject pullRequest;
    private static final ResourceShape DEFAULT_RESOURCE_SHAPE = new ResourceShape();

    public PullRequest(URI cloneLocation, Repository db, JSONObject pullRequest) throws JSONException {
        super(cloneLocation, db);
        Property[] defaultProperties = new Property[]{new Property("CloneLocation"), new Property("RemoteLocation"), new Property(TYPE), new Property("Type")};
        DEFAULT_RESOURCE_SHAPE.setProperties(defaultProperties);
        this.pullRequest = pullRequest;
    }

    @PropertyDescription(name="PullRequest")
    public JSONObject getPullRequest() {
        return this.pullRequest;
    }

    @Override
    @PropertyDescription(name="CloneLocation")
    public URI getCloneLocation() {
        return this.cloneLocation;
    }

    @PropertyDescription(name="RemoteLocation")
    public URI getRemoteLocation() throws URISyntaxException {
        return this.createLocation("remote", this.cloneLocation);
    }

    @PropertyDescription(name="Type")
    public String getType() throws URISyntaxException {
        return TYPE;
    }

    private URI createLocation(String resource, URI cloneLocation) throws URISyntaxException {
        Path basePath = new Path(cloneLocation.getPath());
        IPath newPath = new Path("/gitapi").append(resource).append(basePath.removeFirstSegments(2));
        return new URI(cloneLocation.getScheme(), cloneLocation.getUserInfo(), cloneLocation.getHost(), cloneLocation.getPort(), newPath.toString(), cloneLocation.getQuery(), cloneLocation.getFragment());
    }

    @Override
    public JSONObject toJSON() throws JSONException, URISyntaxException, IOException, CoreException {
        return (JSONObject)this.jsonSerializer.serialize((Object)this, DEFAULT_RESOURCE_SHAPE);
    }

    @Override
    protected URI getLocation() throws URISyntaxException {
        return null;
    }
}

