/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.objects;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.orion.server.cf.objects.CFObject;
import org.eclipse.orion.server.cf.objects.Route;
import org.eclipse.orion.server.core.resources.Property;
import org.eclipse.orion.server.core.resources.ResourceShape;
import org.eclipse.orion.server.core.resources.annotations.PropertyDescription;
import org.eclipse.orion.server.core.resources.annotations.ResourceDescription;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@ResourceDescription(type="App")
public class App2
extends CFObject {
    public static final String RESOURCE = "apps";
    public static final String TYPE = "App";
    protected static final ResourceShape DEFAULT_RESOURCE_SHAPE = new ResourceShape();
    private JSONObject appJSON;
    private List<Route> routes;

    public App2() {
        Property[] defaultProperties = new Property[]{new Property("Guid"), new Property("Name"), new Property("State"), new Property("Routes")};
        DEFAULT_RESOURCE_SHAPE.setProperties(defaultProperties);
    }

    public App2 setCFJSON(JSONObject appJSON) {
        this.appJSON = appJSON;
        return this;
    }

    public JSONObject getCFJSON() {
        return this.appJSON;
    }

    @Override
    protected URI getLocation() throws URISyntaxException {
        return null;
    }

    @PropertyDescription(name="Name")
    public String getName() {
        try {
            return this.appJSON.getJSONObject("entity").getString("name");
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    @PropertyDescription(name="Guid")
    public String getGuid() {
        try {
            return this.appJSON.getJSONObject("metadata").getString("guid");
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    @PropertyDescription(name="State")
    public String getState() {
        try {
            return this.appJSON.getJSONObject("entity").getString("state");
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    @PropertyDescription(name="Routes")
    private JSONArray getRoutesJSON() {
        try {
            JSONArray ret = new JSONArray();
            if (this.routes == null) {
                this.routes = new ArrayList<Route>();
                JSONArray routesJSON = this.appJSON.getJSONObject("entity").getJSONArray("routes");
                int i = 0;
                while (i < routesJSON.length()) {
                    Route route = new Route().setCFJSON(routesJSON.getJSONObject(i));
                    this.routes.add(route);
                    ret.put((Object)route.toJSON());
                    ++i;
                }
            }
            return ret;
        }
        catch (JSONException jSONException) {
            return null;
        }
    }

    @Override
    public JSONObject toJSON() throws JSONException {
        return (JSONObject)this.jsonSerializer.serialize((Object)this, DEFAULT_RESOURCE_SHAPE);
    }
}

