/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.internal.server.servlets.workspace.authorization;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.orion.internal.server.servlets.Activator;
import org.eclipse.orion.internal.server.servlets.workspace.authorization.AuthorizationReader;
import org.eclipse.orion.server.core.OrionConfiguration;
import org.eclipse.orion.server.core.PreferenceHelper;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.metastore.UserInfo;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AuthorizationService {
    public static final int POST = 1;
    public static final int PUT = 2;
    public static final int GET = 4;
    public static final int DELETE = 8;
    private static final String PREFIX_EXPORT = "/xfer/export/";
    private static final String PREFIX_IMPORT = "/xfer/import/";
    private static final String ANONYMOUS_LOGIN_VALUE = "Anonymous";

    public static void addUserRight(String userId, String uri) throws CoreException {
        try {
            UserInfo user = OrionConfiguration.getMetaStore().readUser(userId);
            JSONArray userRightArray = AuthorizationReader.getAuthorizationData(user);
            JSONObject userRight = AuthorizationService.createUserRight(uri);
            int i = 0;
            while (i < userRightArray.length()) {
                if (userRight.toString().equals(userRightArray.get(i).toString())) {
                    return;
                }
                ++i;
            }
            userRightArray.put((Object)userRight);
            AuthorizationReader.saveRights(user, userRightArray);
        }
        catch (Exception e) {
            String msg = "Error persisting user rights";
            throw new CoreException((IStatus)new ServerStatus(4, 500, msg, (Throwable)e));
        }
    }

    public static boolean checkRights(String userId, String uri, String method) throws CoreException {
        if (uri.equals("/workspace") && !ANONYMOUS_LOGIN_VALUE.equals(userId)) {
            return true;
        }
        if (uri.startsWith("/site") && !ANONYMOUS_LOGIN_VALUE.equals(userId)) {
            return true;
        }
        if (uri.equals("/users/" + userId) && !ANONYMOUS_LOGIN_VALUE.equals(userId)) {
            return true;
        }
        if (uri.startsWith("/task")) {
            return true;
        }
        if (uri.startsWith(PREFIX_EXPORT) && uri.endsWith(".zip")) {
            uri = "/file/" + uri.substring(13, uri.length() - 4) + '/';
        } else if (uri.startsWith(PREFIX_IMPORT) && !(uri = "/file/" + uri.substring(PREFIX_IMPORT.length())).endsWith("/")) {
            uri = String.valueOf(uri) + '/';
        }
        String projectWorldReadable = PreferenceHelper.getString((String)"orion.file.anonymous.read", (String)"false");
        int methodMask = AuthorizationService.getMethod(method);
        if (methodMask == 4 && uri.startsWith("/file/") && "true".equalsIgnoreCase(projectWorldReadable)) {
            return !"/file/".equals(uri) && !uri.startsWith("/file/.metadata/");
        }
        UserInfo user = OrionConfiguration.getMetaStore().readUser(userId);
        JSONArray userRightArray = AuthorizationReader.getAuthorizationData(user);
        int i = 0;
        while (i < userRightArray.length()) {
            try {
                JSONObject userRight = (JSONObject)userRightArray.get(i);
                String patternToMatch = userRight.getString("Uri");
                int methodToMatch = userRight.getInt("Method");
                if (AuthorizationService.wildCardMatch(uri, patternToMatch) && (methodMask & methodToMatch) == methodMask) {
                    return true;
                }
            }
            catch (JSONException jSONException) {}
            ++i;
        }
        return false;
    }

    static JSONObject createUserRight(String uri) throws JSONException {
        JSONObject userRight = new JSONObject();
        userRight.put("Uri", (Object)uri);
        userRight.put("Method", 15);
        return userRight;
    }

    private static int getMethod(String methodName) {
        if (methodName.equals("POST")) {
            return 1;
        }
        if (methodName.equals("PUT")) {
            return 2;
        }
        if (methodName.equals("GET")) {
            return 4;
        }
        if (methodName.equals("DELETE")) {
            return 8;
        }
        return 0;
    }

    public static void removeUserRight(String userId, String uri) throws CoreException {
        try {
            Activator.getDefault();
            UserInfo user = OrionConfiguration.getMetaStore().readUser(userId);
            JSONArray userRightArray = AuthorizationReader.getAuthorizationData(user);
            int i = 0;
            while (i < userRightArray.length()) {
                if (uri.equals(((JSONObject)userRightArray.get(i)).get("Uri"))) {
                    userRightArray.remove(i);
                }
                ++i;
            }
            AuthorizationReader.saveRights(user, userRightArray);
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new ServerStatus(4, 500, "Error persisting user rights", (Throwable)e));
        }
    }

    private static boolean wildCardMatch(String text, String pattern) {
        String[] cards = pattern.split("\\*");
        if (!pattern.startsWith("*") && !text.startsWith(cards[0])) {
            return false;
        }
        if (!pattern.endsWith("*") && !text.endsWith(cards[cards.length - 1])) {
            return false;
        }
        String[] stringArray = cards;
        int n = cards.length;
        int n2 = 0;
        while (n2 < n) {
            String card = stringArray[n2];
            int idex = text.indexOf(card);
            if (idex == -1) {
                return false;
            }
            text = text.substring(idex + card.length());
            ++n2;
        }
        return true;
    }
}

