/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.git.servlets;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.orion.internal.server.servlets.ServletResourceHandler;
import org.eclipse.orion.internal.server.servlets.workspace.authorization.AuthorizationService;
import org.eclipse.orion.server.core.ServerStatus;
import org.eclipse.orion.server.core.tasks.IURIUnqualificationStrategy;
import org.eclipse.orion.server.git.BaseToCloneConverter;
import org.eclipse.orion.server.git.objects.ConfigOption;
import org.eclipse.orion.server.git.servlets.GitUtils;
import org.eclipse.orion.server.servlets.JsonURIUnqualificationStrategy;
import org.eclipse.orion.server.servlets.OrionServlet;
import org.eclipse.osgi.util.NLS;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GitConfigHandlerV1
extends ServletResourceHandler<String> {
    private ServletResourceHandler<IStatus> statusHandler;

    GitConfigHandlerV1(ServletResourceHandler<IStatus> statusHandler) {
        this.statusHandler = statusHandler;
    }

    public boolean handleRequest(HttpServletRequest request, HttpServletResponse response, String path) throws ServletException {
        block12: {
            try {
                Path p;
                Path filePath = p = new Path(path);
                if (p.segment(0).equals("clone") && p.segment(1).equals("file")) {
                    filePath = p.removeFirstSegments(1);
                } else if (p.segment(1).equals("clone") && p.segment(2).equals("file")) {
                    filePath = p.removeFirstSegments(2);
                }
                if (AuthorizationService.checkRights((String)request.getRemoteUser(), (String)("/" + filePath.toString()), (String)request.getMethod())) break block12;
                response.sendError(403);
                return true;
            }
            catch (Exception e) {
                String msg = NLS.bind((String)"Failed to process an operation on commits for {0}", (Object)path);
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 500, msg, (Throwable)e));
            }
        }
        switch (GitConfigHandlerV1.getMethod((HttpServletRequest)request)) {
            case GET: {
                return this.handleGet(request, response, path);
            }
            case POST: {
                return this.handlePost(request, response, path);
            }
            case PUT: {
                return this.handlePut(request, response, path);
            }
            case DELETE: {
                return this.handleDelete(request, response, path);
            }
        }
        return false;
    }

    private boolean handleGet(HttpServletRequest request, HttpServletResponse response, String path) throws IOException, JSONException, ServletException, URISyntaxException, CoreException, ConfigInvalidException {
        Path p = new Path(path);
        URI baseLocation = GitConfigHandlerV1.getURI((HttpServletRequest)request);
        if (p.segment(0).equals("clone") && p.segment(1).equals("file")) {
            File gitDir = GitUtils.getGitDir(p.removeFirstSegments(1));
            if (gitDir == null) {
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 404, NLS.bind((String)"No repository found under {0}", (Object)p.removeFirstSegments(1)), null));
            }
            Repository db = null;
            try {
                db = FileRepositoryBuilder.create((File)gitDir);
                URI cloneLocation = BaseToCloneConverter.getCloneLocation(baseLocation, BaseToCloneConverter.CONFIG);
                ConfigOption configOption = new ConfigOption(cloneLocation, db);
                OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)configOption.toJSON(), (IURIUnqualificationStrategy)JsonURIUnqualificationStrategy.ALL_NO_GIT);
                return true;
            }
            finally {
                if (db != null) {
                    db.close();
                }
            }
        }
        if (p.segment(1).equals("clone") && p.segment(2).equals("file")) {
            File gitDir = GitUtils.getGitDir(p.removeFirstSegments(2));
            if (gitDir == null) {
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 404, NLS.bind((String)"No repository found under {0}", (Object)p.removeFirstSegments(2)), null));
            }
            URI cloneLocation = BaseToCloneConverter.getCloneLocation(baseLocation, BaseToCloneConverter.CONFIG_OPTION);
            Repository db = null;
            try {
                db = FileRepositoryBuilder.create((File)gitDir);
                ConfigOption configOption = new ConfigOption(cloneLocation, db, p.segment(0));
                if (!configOption.exists()) {
                    boolean bl = this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 404, "There is no config entry with key provided", null));
                    return bl;
                }
                OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)configOption.toJSON(), (IURIUnqualificationStrategy)JsonURIUnqualificationStrategy.ALL_NO_GIT);
                return true;
            }
            catch (IllegalArgumentException e) {
                boolean bl = this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, e.getMessage(), (Throwable)e));
                return bl;
            }
            finally {
                if (db != null) {
                    db.close();
                }
            }
        }
        return false;
    }

    private boolean handlePost(HttpServletRequest request, HttpServletResponse response, String path) throws CoreException, IOException, JSONException, ServletException, URISyntaxException, ConfigInvalidException {
        Path p = new Path(path);
        if (p.segment(0).equals("clone") && p.segment(1).equals("file")) {
            File gitDir = GitUtils.getGitDir(p.removeFirstSegments(1));
            if (gitDir == null) {
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 404, NLS.bind((String)"No repository found under {0}", (Object)p.removeFirstSegments(1)), null));
            }
            URI cloneLocation = BaseToCloneConverter.getCloneLocation(GitConfigHandlerV1.getURI((HttpServletRequest)request), BaseToCloneConverter.CONFIG);
            JSONObject toPost = OrionServlet.readJSONRequest((HttpServletRequest)request);
            String key = toPost.optString("Key", null);
            if (key == null || key.isEmpty()) {
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "Config entry key must be provided", null));
            }
            String value = toPost.optString("Value", null);
            if (value == null || value.isEmpty()) {
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "Config entry value must be provided", null));
            }
            Repository db = null;
            try {
                db = FileRepositoryBuilder.create((File)gitDir);
                ConfigOption configOption = new ConfigOption(cloneLocation, db, key);
                boolean present = configOption.exists();
                ArrayList<String> valList = new ArrayList<String>();
                if (present) {
                    String[] val = configOption.getValue();
                    valList.addAll(Arrays.asList(val));
                }
                valList.add(value);
                GitConfigHandlerV1.save(configOption, valList);
                JSONObject result = configOption.toJSON();
                OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)result, (IURIUnqualificationStrategy)JsonURIUnqualificationStrategy.ALL_NO_GIT);
                response.setHeader("Location", result.getString("Location"));
                response.setStatus(201);
                return true;
            }
            catch (IllegalArgumentException e) {
                boolean bl = this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, e.getMessage(), (Throwable)e));
                return bl;
            }
            finally {
                if (db != null) {
                    db.close();
                }
            }
        }
        return false;
    }

    private boolean handlePut(HttpServletRequest request, HttpServletResponse response, String path) throws CoreException, IOException, JSONException, ServletException, URISyntaxException, ConfigInvalidException {
        Path p = new Path(path);
        if (p.segment(1).equals("clone") && p.segment(2).equals("file")) {
            File gitDir = GitUtils.getGitDir(p.removeFirstSegments(2));
            if (gitDir == null) {
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 404, NLS.bind((String)"No repository found under {0}", (Object)p.removeFirstSegments(2)), null));
            }
            Repository db = null;
            URI cloneLocation = BaseToCloneConverter.getCloneLocation(GitConfigHandlerV1.getURI((HttpServletRequest)request), BaseToCloneConverter.CONFIG_OPTION);
            try {
                String v;
                db = FileRepositoryBuilder.create((File)gitDir);
                ConfigOption configOption = new ConfigOption(cloneLocation, db, p.segment(0));
                JSONObject toPut = OrionServlet.readJSONRequest((HttpServletRequest)request);
                JSONArray value = toPut.optJSONArray("Value");
                if (value == null && (v = toPut.optString("Value")) != null && v.length() > 0) {
                    value = new JSONArray();
                    value.put((Object)v);
                }
                if (value == null || value.length() == 1 && value.isNull(0)) {
                    boolean bl = this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, "Config entry value must be provided", null));
                    return bl;
                }
                if (!configOption.exists()) {
                    response.setStatus(404);
                    return true;
                }
                ArrayList<String> valList = new ArrayList<String>();
                int i = 0;
                while (i < value.length()) {
                    valList.add(value.getString(i));
                    ++i;
                }
                GitConfigHandlerV1.save(configOption, valList);
                JSONObject result = configOption.toJSON();
                OrionServlet.writeJSONResponse((HttpServletRequest)request, (HttpServletResponse)response, (Object)result);
                response.setHeader("Location", result.getString("Location"));
                return true;
            }
            catch (IllegalArgumentException e) {
                boolean bl = this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, e.getMessage(), (Throwable)e));
                return bl;
            }
            finally {
                if (db != null) {
                    db.close();
                }
            }
        }
        return false;
    }

    private boolean handleDelete(HttpServletRequest request, HttpServletResponse response, String path) throws CoreException, IOException, ServletException, ConfigInvalidException, URISyntaxException {
        Path p = new Path(path);
        if (p.segment(1).equals("clone") && p.segment(2).equals("file")) {
            File gitDir = GitUtils.getGitDir(p.removeFirstSegments(2));
            if (gitDir == null) {
                return this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 404, NLS.bind((String)"No repository found under {0}", (Object)p.removeFirstSegments(2)), null));
            }
            Repository db = null;
            URI cloneLocation = BaseToCloneConverter.getCloneLocation(GitConfigHandlerV1.getURI((HttpServletRequest)request), BaseToCloneConverter.CONFIG_OPTION);
            try {
                db = FileRepositoryBuilder.create((File)gitDir);
                ConfigOption configOption = new ConfigOption(cloneLocation, db, GitUtils.decode(p.segment(0)));
                if (configOption.exists()) {
                    String query = request.getParameter("index");
                    if (query != null) {
                        ArrayList<String> existing = new ArrayList<String>(Arrays.asList(configOption.getValue()));
                        existing.remove(Integer.parseInt(query));
                        GitConfigHandlerV1.save(configOption, existing);
                    } else {
                        GitConfigHandlerV1.delete(configOption);
                    }
                    response.setStatus(200);
                } else {
                    response.setStatus(404);
                }
                return true;
            }
            catch (IllegalArgumentException e) {
                boolean bl = this.statusHandler.handleRequest(request, response, (Object)new ServerStatus(4, 400, e.getMessage(), (Throwable)e));
                return bl;
            }
            finally {
                if (db != null) {
                    db.close();
                }
            }
        }
        return false;
    }

    private static void save(ConfigOption co, List<String> value) throws IOException {
        co.getConfig().setStringList(co.getSection(), co.getSubsection(), co.getName(), value);
        co.getConfig().save();
    }

    private static void delete(ConfigOption co) throws IOException {
        co.getConfig().unset(co.getSection(), co.getSubsection(), co.getName());
        co.getConfig().save();
    }
}

