/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.orion.server.cf.manifest.v2.utils;

import java.util.UUID;
import java.util.regex.Pattern;
import org.eclipse.orion.server.cf.manifest.v2.Analyzer;
import org.eclipse.orion.server.cf.manifest.v2.ManifestParseTree;

public class SymbolResolver
implements Analyzer {
    private String targetBase;
    private Pattern SYMBOL_PATTERN = Pattern.compile("\\$\\{[^ \\t\\n\\x0b\\r\\f\\$\\{\\}]+\\} *");

    public SymbolResolver(String targetBase) {
        this.targetBase = targetBase;
    }

    @Override
    public void apply(ManifestParseTree node) {
        if (node.getChildren().size() == 0) {
            if (this.SYMBOL_PATTERN.matcher(node.getLabel()).find()) {
                this.resolve(node);
            }
        } else {
            for (ManifestParseTree child : node.getChildren()) {
                this.apply(child);
            }
        }
    }

    private void resolve(ManifestParseTree node) {
        if (this.targetBase != null && node.getLabel().contains("${target-base}")) {
            node.setLabel(node.getLabel().replaceAll("\\$\\{target-base\\}", this.targetBase));
        }
        if (node.getLabel().contains("${random-word}")) {
            node.setLabel(node.getLabel().replaceAll("\\$\\{random-word\\}", UUID.randomUUID().toString()));
        }
    }
}

