/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.sample.utility;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.BevelBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.eclipse.paho.sample.utility.MQTTFrame;

public class PubPanel
implements ActionListener,
DocumentListener {
    private JPanel pubPanel;
    private JComboBox topic;
    private Integer[] qos = new Integer[]{new Integer(0), new Integer(1), new Integer(2)};
    private JComboBox qosList;
    private JButton pubButton;
    private JButton fileButton;
    private JButton hexButton;
    private boolean hexDisplay = false;
    private JTextArea pubData;
    private JCheckBox retained;
    private MQTTFrame mqttMgr = null;
    private JLabel pubLabel = null;
    private static final String PANEL_TITLE = " Publish Messages";
    private File fileChooserCurrentDir = null;
    private byte[] fileContent = null;

    public PubPanel(JPanel thePubPanel, MQTTFrame aMqttMgr) {
        this.pubPanel = thePubPanel;
        this.pubPanel.setBorder(new EtchedBorder());
        this.mqttMgr = aMqttMgr;
        this.init();
    }

    public void init() {
        this.pubPanel.setLayout(new BorderLayout());
        this.topic = new JComboBox();
        this.topic.setEditable(true);
        this.topic.setMaximumSize(MQTTFrame.TEXT_FIELD_DIMENSION);
        this.topic.setMaximumRowCount(5);
        this.qosList = new JComboBox<Integer>(this.qos);
        this.qosList.setSelectedIndex(0);
        this.qosList.setMaximumSize(MQTTFrame.DROP_DOWN_DIMENSION);
        this.pubData = new JTextArea(3, 30);
        this.pubData.setBorder(new BevelBorder(1));
        this.pubData.setMargin(MQTTFrame.TEXT_MARGINS);
        this.retained = new JCheckBox();
        this.retained.setSelected(false);
        this.pubLabel = new JLabel(" Publish Messages - text display");
        Font f = this.pubLabel.getFont();
        this.pubLabel.setFont(new Font(f.getName(), 1, f.getSize() + 1));
        JPanel topicBox = new JPanel();
        topicBox.setLayout(new BoxLayout(topicBox, 0));
        topicBox.add(new JLabel(" Topic:"));
        topicBox.add(this.topic);
        topicBox.add(new JLabel(" QoS:"));
        topicBox.add(this.qosList);
        topicBox.add(new JLabel(" Retained:"));
        topicBox.add(this.retained);
        JPanel titleAndTopic = new JPanel();
        titleAndTopic.setLayout(new GridLayout(2, 1));
        titleAndTopic.add(this.pubLabel);
        titleAndTopic.add(topicBox);
        this.hexDisplay = false;
        this.hexButton = new JButton("Hex");
        this.hexButton.addActionListener(this);
        this.fileButton = new JButton("File...");
        this.fileButton.setEnabled(true);
        this.fileButton.addActionListener(this);
        this.pubButton = new JButton("Publish");
        this.pubButton.setEnabled(false);
        this.pubButton.addActionListener(this);
        JPanel buttons = new JPanel();
        buttons.setLayout(new GridLayout(3, 1));
        buttons.add(this.pubButton);
        buttons.add(this.fileButton);
        buttons.add(this.hexButton);
        JPanel buttonLayout = new JPanel();
        buttonLayout.add(buttons);
        this.pubPanel.add((Component)titleAndTopic, "North");
        this.pubPanel.add((Component)new JScrollPane(this.pubData), "Center");
        this.pubPanel.add((Component)buttonLayout, "East");
    }

    public boolean updateTopicList(String topicName) {
        return this.mqttMgr.updateComboBoxList(this.topic, topicName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        boolean hexData = this.hexDisplay;
        boolean pubSuccess = false;
        if (e.getActionCommand().equals("Publish")) {
            if (this.hexDisplay) {
                this.toCharString();
            }
            String pubText = this.pubData.getText();
            String topicName = (String)this.topic.getSelectedItem();
            if (this.updateTopicList(topicName)) {
                this.mqttMgr.updateSubscribeTopicList(topicName);
            }
            Exception pubExp = null;
            try {
                this.mqttMgr.publish(topicName, this.fileContent == null ? pubText.getBytes() : this.fileContent, this.qosList.getSelectedIndex(), this.retained.isSelected());
                pubSuccess = true;
            }
            catch (Exception ex) {
                pubSuccess = false;
                pubExp = ex;
            }
            if (hexData) {
                this.toHexString();
            }
            MQTTFrame mQTTFrame = this.mqttMgr;
            synchronized (mQTTFrame) {
                if (pubSuccess) {
                    this.mqttMgr.writeLogln("  --> PUBLISH sent,     TOPIC:" + topicName + ", QoS:" + this.qosList.getSelectedIndex() + ", Retained:" + this.retained.isSelected());
                } else {
                    this.mqttMgr.writeLogln(" *--> PUBLISH send FAILED, TOPIC:" + topicName + ", QoS:" + this.qosList.getSelectedIndex() + ", Retained:" + this.retained.isSelected());
                }
                this.mqttMgr.writeLog("                        DATA:");
                if (hexData) {
                    this.mqttMgr.writeLog("0x");
                }
                this.mqttMgr.writeLogln(this.pubData.getText());
                if (!pubSuccess) {
                    this.mqttMgr.writeLogln("                   EXCEPTION:" + pubExp.getMessage());
                }
            }
        }
        if (e.getActionCommand().equals("File...")) {
            JFileChooser selectFile = new JFileChooser(this.fileChooserCurrentDir);
            selectFile.setMultiSelectionEnabled(false);
            if (selectFile.showOpenDialog(this.pubPanel) == 0) {
                this.fileChooserCurrentDir = selectFile.getCurrentDirectory();
                File theFile = selectFile.getSelectedFile();
                this.fileContent = new byte[(int)theFile.length()];
                try {
                    FileInputStream input = new FileInputStream(theFile);
                    input.read(this.fileContent);
                    this.pubData.setText(new String(this.fileContent));
                    this.pubData.getDocument().addDocumentListener(this);
                }
                catch (FileNotFoundException fnfe) {
                    JOptionPane.showMessageDialog(this.pubPanel, fnfe.getMessage(), "File Open Error", 0);
                }
                catch (IOException ioe) {
                    JOptionPane.showMessageDialog(this.pubPanel, ioe.getMessage(), "File Open Error", 0);
                }
            }
        } else if (!this.hexDisplay) {
            this.toHexString();
        } else {
            this.toCharString();
        }
    }

    private void toHexString() {
        String pubText = this.pubData.getText();
        StringBuffer hexText = new StringBuffer();
        byte[] pubBytes = pubText.getBytes();
        for (int i = 0; i < pubBytes.length; ++i) {
            int byteValue = pubBytes[i];
            if (byteValue < 0) {
                byteValue += 256;
            }
            if (byteValue < 16) {
                hexText.append("0" + Integer.toHexString(byteValue));
                continue;
            }
            hexText.append(Integer.toHexString(byteValue));
        }
        this.hexDisplay = true;
        this.pubLabel.setText(" Publish Messages - hexadecimal display");
        this.mqttMgr.setTitleText("");
        this.hexButton.setText("Text");
        this.pubData.setText(hexText.toString());
    }

    private void toCharString() {
        String hexText = this.pubData.getText();
        if (hexText.length() % 2 != 0) {
            this.mqttMgr.setTitleText("Odd number of hex characters!");
        } else {
            try {
                byte[] charArray = new byte[hexText.length() / 2];
                for (int i = 0; i < charArray.length; ++i) {
                    charArray[i] = (byte)Integer.parseInt(hexText.substring(i * 2, i * 2 + 2), 16);
                }
                this.hexDisplay = false;
                this.pubLabel.setText(" Publish Messages - text display");
                this.mqttMgr.setTitleText("");
                this.hexButton.setText("Hex");
                this.pubData.setText(new String(charArray));
            }
            catch (NumberFormatException nfe) {
                this.mqttMgr.setTitleText("Invalid hexadecimal data!");
            }
        }
    }

    public void enableButtons(boolean b) {
        this.pubButton.setEnabled(b);
    }

    @Override
    public void changedUpdate(DocumentEvent de) {
        this.fileContent = null;
        this.pubData.getDocument().removeDocumentListener(this);
    }

    @Override
    public void insertUpdate(DocumentEvent de) {
        this.changedUpdate(de);
    }

    @Override
    public void removeUpdate(DocumentEvent de) {
        this.changedUpdate(de);
    }
}

