/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.registry;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.passage.lic.api.registry.Registry;
import org.eclipse.passage.lic.api.registry.Service;
import org.eclipse.passage.lic.api.registry.ServiceId;
import org.eclipse.passage.lic.internal.base.i18n.BaseMessages;

public final class JointRegistry<I extends ServiceId, S extends Service<I>>
implements Registry<I, S> {
    private final List<Registry<I, S>> delegates;

    public JointRegistry(List<Registry<I, S>> delegates) {
        this.delegates = delegates;
    }

    public boolean hasService(I id) {
        return this.delegates.stream().anyMatch(delegate -> delegate.hasService(id));
    }

    public S service(I id) {
        return (S)this.delegates.stream().filter(delgate -> delgate.hasService(id)).map(delgate -> delgate.service(id)).findAny().orElseThrow(() -> new IllegalStateException(this.notFoundMessage((ServiceId)id)));
    }

    public Collection<S> services() {
        return this.delegates.stream().map(Registry::services).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private String notFoundMessage(ServiceId id) {
        return String.format(BaseMessages.getString("JointRegistry.retrieve_absent"), id, this.delegates.size(), this.delegates.stream().map(Object::toString).collect(Collectors.joining("\n\t")));
    }
}

