/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.api.tests.conditions.evaluation;

import org.eclipse.passage.lic.api.conditions.evaluation.ExpressionParsingException;
import org.eclipse.passage.lic.api.conditions.evaluation.ExpressionParsingService;
import org.eclipse.passage.lic.api.conditions.evaluation.ParsedExpression;
import org.junit.Assert;
import org.junit.Test;

public abstract class ExpressionParsingServiceContractTest {
    @Test(expected=ExpressionParsingException.class)
    public final void blankExpressionCausesFailure() throws ExpressionParsingException {
        this.parser().parsed("\t");
    }

    @Test(expected=NullPointerException.class)
    public final void prohibitsNullExpression() throws ExpressionParsingException {
        this.parser().parsed(null);
    }

    @Test
    public final void producesSameProtocolResult() {
        ExpressionParsingService parser = this.parser();
        try {
            Assert.assertEquals((Object)parser.id(), (Object)parser.parsed(this.validExpression()).protocol());
        }
        catch (ExpressionParsingException expressionParsingException) {
            Assert.fail((String)"Is not expected to fail on valid data");
        }
    }

    @Test
    public final void producesResultOfExpectedType() throws ExpressionParsingException {
        Assert.assertTrue((boolean)this.resultType().isInstance(this.parser().parsed(this.validExpression())));
    }

    protected abstract ExpressionParsingService parser();

    protected abstract String validExpression();

    protected abstract Class<? extends ParsedExpression> resultType();
}

