/*
 * Decompiled with CFR 0.152.
 */
package oshi.software.os.mac;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oshi.software.os.ApplicationInfo;
import oshi.util.ExecutingCommand;
import oshi.util.ParseUtil;

public final class MacInstalledApps {
    private static final String COLON = ":";

    private MacInstalledApps() {
    }

    public static List<ApplicationInfo> queryInstalledApps() {
        List<String> output = ExecutingCommand.runNative("system_profiler SPApplicationsDataType");
        return MacInstalledApps.parseMacAppInfo(output);
    }

    private static List<ApplicationInfo> parseMacAppInfo(List<String> lines) {
        ArrayList<ApplicationInfo> appInfoList = new ArrayList<ApplicationInfo>();
        String appName = null;
        HashMap<String, String> appDetails = null;
        boolean collectingAppDetails = false;
        for (String line : lines) {
            if ((line = line.trim()).endsWith(COLON)) {
                if (appName != null && !appDetails.isEmpty()) {
                    appInfoList.add(MacInstalledApps.createAppInfo(appName, (Map<String, String>)appDetails));
                }
                appName = line.substring(0, line.length() - 1);
                appDetails = new HashMap<String, String>();
                collectingAppDetails = true;
                continue;
            }
            if (!collectingAppDetails || !line.contains(COLON)) continue;
            int colonIndex = line.indexOf(COLON);
            String key = line.substring(0, colonIndex).trim();
            String value = line.substring(colonIndex + 1).trim();
            appDetails.put(key, value);
        }
        return appInfoList;
    }

    private static ApplicationInfo createAppInfo(String name, Map<String, String> details) {
        String obtainedFrom = ParseUtil.getValueOrUnknown(details, "Obtained from");
        String signedBy = ParseUtil.getValueOrUnknown(details, "Signed by");
        String vendor = obtainedFrom.equals("Identified Developer") ? signedBy : obtainedFrom;
        String lastModified = details.getOrDefault("Last Modified", "unknown");
        long lastModifiedEpoch = ParseUtil.parseDateToEpoch(lastModified, "dd/MM/yy, HH:mm");
        HashMap<String, String> additionalInfo = new HashMap<String, String>();
        additionalInfo.put("Kind", ParseUtil.getValueOrUnknown(details, "Kind"));
        additionalInfo.put("Location", ParseUtil.getValueOrUnknown(details, "Location"));
        additionalInfo.put("Get Info String", ParseUtil.getValueOrUnknown(details, "Get Info String"));
        return new ApplicationInfo(name, ParseUtil.getValueOrUnknown(details, "Version"), vendor, lastModifiedEpoch, additionalInfo);
    }
}

