/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.jface.dialogs.licensing;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.api.LicensingException;
import org.eclipse.passage.lic.api.ServiceInvocationResult;
import org.eclipse.passage.lic.api.conditions.mining.LicenseReadingService;
import org.eclipse.passage.lic.api.conditions.mining.MiningEquipment;
import org.eclipse.passage.lic.api.diagnostic.Diagnostic;
import org.eclipse.passage.lic.base.conditions.mining.BaseLicenseReadingService;
import org.eclipse.passage.lic.base.diagnostic.DiagnosticExplained;
import org.eclipse.passage.lic.base.diagnostic.NoSevereErrors;
import org.eclipse.passage.lic.base.io.ExternalLicense;
import org.eclipse.passage.lic.equinox.SuppliedFrameworkAware;
import org.eclipse.passage.lic.internal.base.access.Libraries;
import org.eclipse.passage.lic.internal.jface.i18n.ImportLicenseDialogMessages;

final class LicenseSet {
    private final LicensedProduct product;
    private final List<Path> licenses;
    private final Optional<Libraries> libraries;
    private final Consumer<String> error;
    private final Optional<LicenseReadingService> service;

    LicenseSet(List<Path> licenses, LicensedProduct product, Optional<Libraries> libraries, Consumer<String> error) {
        this.licenses = licenses;
        this.product = product;
        this.libraries = libraries;
        this.error = error;
        this.service = this.productLicenseReadingService();
    }

    private Optional<LicenseReadingService> productLicenseReadingService() {
        return this.miner().map(miner -> new BaseLicenseReadingService(this.product, miner));
    }

    private Optional<MiningEquipment> miner() {
        return new SuppliedFrameworkAware().withFramework(framework -> framework.accessCycleConfiguration().miningEquipment());
    }

    void install() {
        this.licenses.forEach(file -> this.doLicenseImport((Path)file));
    }

    private void doLicenseImport(Path license) {
        try {
            this.installLibraryLicense(license);
            this.installProductLicense(license);
        }
        catch (Exception e) {
            this.error.accept(String.format(ImportLicenseDialogMessages.ImportLicenseDialog_io_error, e.getLocalizedMessage()));
        }
    }

    private void installProductLicense(Path license) throws IOException {
        if (!this.productRelevantLicense(license)) {
            return;
        }
        new ExternalLicense(this.product).install(new Path[]{license});
    }

    private void installLibraryLicense(Path license) throws Exception {
        if (this.libraries.isEmpty()) {
            return;
        }
        Optional result = this.libraries.get().installLicense(license);
        if (!result.isPresent()) {
            return;
        }
        ServiceInvocationResult status = (ServiceInvocationResult)result.get();
        Diagnostic diagnostic = status.diagnostic();
        System.out.println("Import license license: " + String.valueOf(license));
        System.out.println(new DiagnosticExplained(diagnostic).get());
        if (!new NoSevereErrors().test(diagnostic)) {
            throw new LicensingException(String.format("License file [%s] failed to be imported", license));
        }
    }

    private boolean productRelevantLicense(Path license) {
        if (!this.service.isPresent()) {
            return false;
        }
        return this.service.get().read(license).data().map(conditions -> !conditions.isEmpty()).orElse(Boolean.FALSE);
    }
}

